/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.prescription;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.prescription.PrescriptionInfo;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.prescription.PrescriptionWidget;
import com.equestricraft.mod.horse.prescription.HorsePrescriptionPage;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPrescriptionListPageRequestPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class PrescriptionListMenu
extends PageScreen<HorsePrescriptionPage, PrescriptionInfo, Object, Object> {
    private final int horseId;
    private int scroll = 0;
    private int totalHeight;

    public static void showMenu(int horseId, HorsePrescriptionPage page) {
        PrescriptionListMenu screen = new PrescriptionListMenu(horseId, page);
        ScreenStack.getInstance().push(screen);
    }

    private PrescriptionListMenu(int horseId, HorsePrescriptionPage page) {
        super(I18n.getLabel("prescription.list.menu.title"), page);
        this.horseId = horseId;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PrescriptionListMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        int x = 10;
        int y = 35;
        int widgetWidth = this.f_96543_ - 20;
        for (PrescriptionInfo item : ((HorsePrescriptionPage)this.page).getItems()) {
            PrescriptionWidget widget = new PrescriptionWidget(x, y + this.scroll, widgetWidth, item);
            widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
            y += widget.m_93694_() + 5;
        }
        this.totalHeight = y;
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        double newVal = (double)this.scroll + scroll * 12.0;
        if (newVal > 0.0) {
            newVal = 0.0;
        } else {
            double limit = (double)this.totalHeight - (double)this.f_96544_ / 2.0 + 10.0;
            if (Math.abs(newVal) > limit) {
                newVal = -limit;
            }
        }
        this.scroll = (int)newVal;
        return false;
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundPrescriptionListPageRequestPacket packet = new ServerBoundPrescriptionListPageRequestPacket(this.horseId, newPageNumber, SortDirection.ASCENDING);
        Network.sendToServer(packet);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

