/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.prescription;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.prescription.PrescriptionInfo;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;

public class PrescriptionWidget
extends ECWidget {
    private final ECField ageField;
    private final List<ECField> medicineFields = new ArrayList<ECField>();
    private final ECMultiLineField descriptionField;

    protected PrescriptionWidget(int x, int y, int width, PrescriptionInfo prescriptionInfo) {
        super(x, y, width, 0);
        int currentY = 0;
        this.ageField = ECField.Builder.start(this.dx(0), this.dy(currentY), width).withLabel(I18n.getLabel("prescription.list.field.days-since.label")).withValue(prescriptionInfo.daysSinceGiven()).complete();
        currentY += this.ageField.m_93694_();
        for (PrescriptionInfo.PrescriptionMedicine medicine : prescriptionInfo.prescriptionMedicines()) {
            ECField medicineField = ECField.Builder.start(this.dx(0), this.dy(currentY), width).withValue(I18n.getLabel("prescription.list.field.medicine.label", medicine.medicineName(), medicine.dosageAmount(), medicine.dosageUnitName(), medicine.durationHours())).complete();
            this.medicineFields.add(medicineField);
            currentY += medicineField.m_93694_();
        }
        this.descriptionField = ECMultiLineField.Builder.start().withLabel(prescriptionInfo.description()).withWidth(width).withPosition(this.dx(0), this.dy(currentY)).complete();
        this.setHeight(currentY += this.descriptionField.getHeight());
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.ageField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        for (ECField medicineField : this.medicineFields) {
            medicineField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        this.descriptionField.render(poseStack);
    }
}

