/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.prompt;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class BasePromptScreen
extends Screen {
    protected final UUID uuid;
    private final String message;
    protected boolean shouldSendCancel = true;
    private ECMultiLineField messageLabel;
    private int halfMessageHeight = 0;

    protected BasePromptScreen(UUID uuid, String title, String message) {
        super((Component)ComponentUtil.buildColoredTextComponent(title));
        this.uuid = uuid;
        this.message = message;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.messageLabel = ECMultiLineField.Builder.start().withLabel(this.message).withWidth(this.f_96543_ - 80).centerAlign().complete();
        this.halfMessageHeight = this.messageLabel.getHeight() / 2;
        ECButton okButton = ECButton.Builder.start(this.f_96543_ / 2, 175, 150, 20).withLabel(I18n.getLabel("common.ok")).withOnClick(() -> {
            if (this.isValid()) {
                this.shouldSendCancel = false;
                this.m_7379_();
            }
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)okButton);
    }

    protected void renderWithScale(PoseStack poseStack, double scale, Runnable render) {
        poseStack.m_85837_((double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0, 0.0);
        poseStack.m_85841_((float)scale, (float)scale, 1.0f);
        render.run();
        poseStack.m_85841_((float)(1.0 / scale), (float)(1.0 / scale), 1.0f);
        poseStack.m_85837_((double)(-this.f_96543_) / 2.0, (double)(-this.f_96544_) / 2.0, 0.0);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        BasePromptScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)Math.max(10, 30 - this.halfMessageHeight), (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.messageLabel.position(this.f_96543_ / 2, Math.max(30, 50 - this.halfMessageHeight)).render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    protected abstract boolean isValid();
}

