/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.prompt;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundConfirmPromptResponsePacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConfirmPromptScreen
extends Screen {
    private final UUID uuid;
    private final String message;
    private ECMultiLineField messageComponent = null;
    private boolean shouldSendCancel = true;
    private int halfMessageHeight = 0;

    public static void showConfirmPromptScreen(UUID uuid, String title, String message) {
        ConfirmPromptScreen prompt = new ConfirmPromptScreen(uuid, title, message);
        Minecraft.m_91087_().m_91152_((Screen)prompt);
    }

    public ConfirmPromptScreen(UUID uuid, String title, String message) {
        super((Component)ComponentUtil.buildColoredTextComponent(title));
        this.uuid = uuid;
        this.message = message;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.messageComponent = ECMultiLineField.Builder.start().withLabel(this.message).withWidth(this.f_96543_ - 50).centerAlign().complete();
        this.halfMessageHeight = this.messageComponent.getHeight() / 2;
        ECButton yesButton = ECButton.Builder.start(this.f_96543_ / 2 - 55, 185, 100, 20).withLabel(I18n.getLabel("common.yes")).withOnClick(() -> {
            this.shouldSendCancel = false;
            super.m_7379_();
            Network.sendToServer(new ServerBoundConfirmPromptResponsePacket(this.uuid, ConfirmResponse.YES));
        }).centerAligned().complete();
        ECButton noButton = ECButton.Builder.start(this.f_96543_ / 2 + 55, 185, 100, 20).withLabel(I18n.getLabel("common.no")).withOnClick(() -> {
            this.shouldSendCancel = false;
            super.m_7379_();
            Network.sendToServer(new ServerBoundConfirmPromptResponsePacket(this.uuid, ConfirmResponse.NO));
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)yesButton);
        this.m_142416_((GuiEventListener)noButton);
    }

    public void m_6305_(PoseStack poseStack, int val1, int val2, float val3) {
        this.m_7333_(poseStack);
        ConfirmPromptScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)Math.max(10, 40 - this.halfMessageHeight), (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.messageComponent.position(this.f_96543_ / 2, Math.max(30, 60 - this.halfMessageHeight)).render(poseStack);
        super.m_6305_(poseStack, val1, val2, val3);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.shouldSendCancel) {
            Network.sendToServer(new ServerBoundConfirmPromptResponsePacket(this.uuid, ConfirmResponse.CANCEL));
        }
    }
}

