/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.prompt;

import com.equestricraft.common.Range;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.prompt.BasePromptScreen;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundNumberPromptResponsePacket;
import com.equestricraft.mod.prompt.MessagePrompt;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NumberPromptScreen
extends BasePromptScreen {
    private final Integer minimumValue;
    private final Integer maximumValue;
    private final Integer decimalPoints;
    private EditBox numberDisplayBox;
    private final String validationMessage;
    private boolean inputIsValid = false;

    public static void showNumberPromptScreen(UUID uuid, String title, String message, Integer minimumValue, Integer maximumValue, Integer decimalPoints) {
        NumberPromptScreen prompt = new NumberPromptScreen(uuid, title, message, minimumValue, maximumValue, decimalPoints);
        Minecraft.m_91087_().m_91152_((Screen)prompt);
    }

    public NumberPromptScreen(UUID uuid, String title, String message, Integer minimumValue, Integer maximumValue, Integer decimalPoints) {
        super(uuid, title, message);
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.decimalPoints = decimalPoints;
        this.validationMessage = this.buildValidationMessage();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.numberDisplayBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 105, 200, 20, (Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("prompt.number.enter-number")));
        this.numberDisplayBox.m_94153_(this::filter);
        this.m_7787_((GuiEventListener)this.numberDisplayBox);
        this.m_94718_((GuiEventListener)this.numberDisplayBox);
    }

    private boolean filter(String strValue) {
        if (strValue.isEmpty()) {
            return true;
        }
        if (this.isInputNumerical(strValue)) {
            return false;
        }
        try {
            Double dMax;
            double value = Double.parseDouble(strValue);
            Double dMin = this.minimumValue != null ? Double.valueOf(this.minimumValue.intValue()) : null;
            Double d = dMax = this.maximumValue != null ? Double.valueOf(this.maximumValue.intValue()) : null;
            if (Range.of(dMin, dMax).containsValueWithin(value)) {
                this.numberDisplayBox.m_94202_(GuiConstants.COLOR_WHITE);
                this.inputIsValid = true;
            } else {
                this.numberDisplayBox.m_94202_(GuiConstants.COLOR_STRONGER_RED);
                this.inputIsValid = false;
            }
        }
        catch (NumberFormatException ex) {
            this.numberDisplayBox.m_94202_(GuiConstants.COLOR_STRONGER_RED);
            this.inputIsValid = false;
        }
        return true;
    }

    private boolean isInputNumerical(String strValue) {
        boolean decimal = false;
        for (int i = 0; i < strValue.length(); ++i) {
            char c = strValue.charAt(i);
            if (this.isDash(c) || !decimal && this.isPoint(c) && this.decimalPoints != 0 && strValue.length() - i < this.decimalPoints + 2) {
                decimal = true;
                continue;
            }
            if (this.isNumber(c)) continue;
            return true;
        }
        return false;
    }

    private boolean isDash(char c) {
        return c == '-';
    }

    private boolean isPoint(char c) {
        return c == '.';
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private String buildValidationMessage() {
        String validation = "";
        String validationMessages = this.validationMessages();
        if (!validationMessages.isEmpty()) {
            validation = I18n.getLabel("prompt.number.validation.must-have", validationMessages);
        }
        return validation;
    }

    private String validationMessages() {
        LinkedList<String> messages = new LinkedList<String>();
        if (this.minimumValue != null) {
            messages.add(I18n.getLabel("prompt.number.validation.minimum-value", this.minimumValue));
        }
        if (this.maximumValue != null) {
            messages.add(I18n.getLabel("prompt.number.validation.maximum-value", this.maximumValue));
        }
        if (this.decimalPoints != null) {
            messages.add(I18n.getLabel("prompt.number.validation.decimal-places", this.decimalPoints));
        }
        return String.join((CharSequence)", ", messages);
    }

    public boolean m_7933_(int keyId, int va1, int va2) {
        String value = this.numberDisplayBox.m_94155_();
        if (keyId == 45 && !value.isEmpty()) {
            if (value.charAt(0) == '-') {
                this.numberDisplayBox.m_94144_(value.substring(1));
            } else {
                this.numberDisplayBox.m_94144_("-" + value);
            }
        }
        this.inputIsValid = !value.isEmpty();
        return super.m_7933_(keyId, va1, va2);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int color;
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.numberDisplayBox.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.inputIsValid) {
            color = GuiConstants.COLOR_WHITE;
        } else {
            GuiUtil.drawImage(poseStack, MessagePrompt.MessagePromptType.ALERT.getTexture(), this.numberDisplayBox.f_93620_ - 16, 109, 11, 11);
            color = GuiConstants.COLOR_STRONGER_RED;
        }
        this.renderWithScale(poseStack, 0.5, () -> NumberPromptScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.validationMessage, (int)0, (int)0, (int)color));
    }

    @Override
    protected boolean isValid() {
        return this.inputIsValid;
    }

    public void m_7379_() {
        super.m_7379_();
        if (!this.inputIsValid || this.shouldSendCancel) {
            Network.sendToServer(new ServerBoundNumberPromptResponsePacket(this.uuid, null));
        } else {
            Network.sendToServer(new ServerBoundNumberPromptResponsePacket(this.uuid, Double.valueOf(this.numberDisplayBox.m_94155_())));
        }
    }
}

