/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.prompt;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.prompt.OptionPromptItemData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class OptionItemWidget
extends ECWidget {
    private final OptionPromptItemData item;
    private final Consumer<OptionPromptItemData> onClick;
    private final boolean selected;
    private final ECField nameField;
    private ECMultiLineField descriptionLabel = null;
    private boolean enabled = true;

    protected OptionItemWidget(int x, int y, int width, OptionPromptItemData item, Consumer<OptionPromptItemData> onClick) {
        this(x, y, width, item, onClick, false);
    }

    protected OptionItemWidget(int x, int y, int width, OptionPromptItemData item, Consumer<OptionPromptItemData> onClick, boolean selected) {
        super(x, y, width, 0);
        this.item = item;
        this.onClick = onClick;
        this.selected = selected;
        this.nameField = ECField.Builder.start(this.dx(width / 2), this.dy(5), width).withValue(item.label()).centerAligned().complete();
        int height = 20;
        if (item.description() != null) {
            this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(item.description()).withWidth(width - 3).centerAlign().complete();
            height += this.descriptionLabel.getHeight();
        }
        this.setHeight(height);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.enabled && (this.selected || this.isWithin(mouseX, mouseY))) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, new Argb(60, 220, 220, 220));
        } else {
            GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, new Argb(20, 150, 150, 150));
        }
        if (this.enabled) {
            this.nameField.setValueColor(Argb.ARGB_MC_AQUA);
        } else {
            this.nameField.setValueColor(Argb.ARGB_MC_GRAY);
        }
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.position(this.dx(this.f_93618_ / 2), this.dy(20)).render(poseStack);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (this.enabled) {
            this.onClick.accept(this.item);
        }
        return true;
    }
}

