/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.prompt;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.prompt.OptionItemWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundSingleSelectOptionPromptResponsePacket;
import com.equestricraft.mod.prompt.OptionPromptItemData;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SingleSelectOptionPromptScreen
extends Screen {
    private final UUID uuid;
    private final String message;
    private final List<OptionPromptItemData> options;
    private boolean sendCancel = true;
    private int scroll = 0;
    private int totalHeight = 0;
    private ECMultiLineField messageLabel = null;
    private List<OptionItemWidget> widgets = new ArrayList<OptionItemWidget>(0);
    private long showTime = System.currentTimeMillis();

    public static void showSingleSelectOptionPromptScreen(UUID uuid, String title, String message, List<OptionPromptItemData> options) {
        SingleSelectOptionPromptScreen prompt = new SingleSelectOptionPromptScreen(uuid, title, message, options);
        Minecraft.m_91087_().m_91152_((Screen)prompt);
    }

    public SingleSelectOptionPromptScreen(UUID uuid, String title, String message, List<OptionPromptItemData> options) {
        super((Component)ComponentUtil.buildColoredTextComponent(title));
        this.uuid = uuid;
        this.message = message;
        this.options = options;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.message != null) {
            this.messageLabel = ECMultiLineField.Builder.start().withLabel(this.message).withWidth(this.f_96543_ - 80).centerAlign().complete();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        SingleSelectOptionPromptScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(10 + this.scroll), (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        int y = 25;
        if (this.message != null) {
            this.messageLabel.position(this.f_96543_ / 2, 25 + this.scroll).render(poseStack);
            y += this.messageLabel.getHeight();
        }
        y += 10;
        int widgetWidth = this.options.stream().map(OptionPromptItemData::label).map(GuiUtil::getStandardTextWidth).max(Integer::compare).orElse(180) + 10;
        widgetWidth = Math.min(widgetWidth, this.f_96543_ - 20);
        int x = this.f_96543_ / 2 - widgetWidth / 2;
        ArrayList<OptionItemWidget> widgets = new ArrayList<OptionItemWidget>(0);
        boolean enableButtons = this.shouldButtonsEnable();
        for (OptionPromptItemData option : this.options) {
            OptionItemWidget widget = new OptionItemWidget(x, y + this.scroll, widgetWidth, option, this::onItemClick);
            widget.setEnabled(enableButtons);
            widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
            widgets.add(widget);
            y += widget.m_93694_() + 5;
        }
        this.widgets = widgets;
        this.totalHeight = y + 10;
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private boolean shouldButtonsEnable() {
        return DateUtils.durationSince(this.showTime).toSeconds() >= 2L;
    }

    private void onItemClick(OptionPromptItemData item) {
        this.sendCancel = false;
        this.m_7379_();
        ServerBoundSingleSelectOptionPromptResponsePacket packet = new ServerBoundSingleSelectOptionPromptResponsePacket(this.uuid, item.id());
        Network.sendToServer(packet);
    }

    public boolean m_6375_(double mouseX, double mouseY, int action) {
        for (OptionItemWidget widget : this.widgets) {
            if (!widget.m_6375_(mouseX, mouseY, action)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        double newVal = (double)this.scroll + scroll * 12.0;
        if (newVal > 0.0) {
            newVal = 0.0;
        } else {
            double limit = (double)this.totalHeight - (double)this.f_96544_ / 2.0 + 10.0;
            if (Math.abs(newVal) > limit) {
                newVal = -limit;
            }
        }
        this.scroll = (int)newVal;
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.sendCancel) {
            ServerBoundSingleSelectOptionPromptResponsePacket packet = new ServerBoundSingleSelectOptionPromptResponsePacket(this.uuid, null);
            Network.sendToServer(packet);
        }
    }
}

