/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.prompt;

import com.equestricraft.common.Range;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECTextBox;
import com.equestricraft.mod.client.gui.prompt.BasePromptScreen;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundTextPromptResponsePacket;
import com.equestricraft.mod.prompt.MessagePrompt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextMultiLinePromptScreen
extends BasePromptScreen {
    private final Integer minimumLength;
    private final Integer maximumLength;
    private ECTextBox textInputBox;
    private boolean inputIsValid = false;

    public static void showMultiLineTextPromptScreen(UUID uuid, String title, String message, Integer minimumLength, Integer maximumLength) {
        TextMultiLinePromptScreen prompt = new TextMultiLinePromptScreen(uuid, title, message, minimumLength, maximumLength);
        Minecraft.m_91087_().m_91152_((Screen)prompt);
    }

    public TextMultiLinePromptScreen(UUID uuid, String title, String message, Integer minimumLength, Integer maximumLength) {
        super(uuid, title, message);
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.textInputBox = ECTextBox.Builder.start(this.f_96543_ / 2 - 100, 105, 200, 50).withLabel(I18n.getLabel("prompt.text.enter-text")).withFilter(this::filter).complete();
        this.m_142416_((GuiEventListener)this.textInputBox);
        this.m_94718_((GuiEventListener)this.textInputBox);
    }

    private boolean filter(String value) {
        this.inputIsValid = Range.of(this.minimumLength, this.maximumLength).containsValueWithin(value.length());
        return true;
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (!this.inputIsValid) {
            GuiUtil.drawImage(poseStack, MessagePrompt.MessagePromptType.ALERT.getTexture(), this.textInputBox.f_93620_ - 16, 109, 11, 11);
            String minimumLabel = this.minimumLength != null && this.minimumLength != 0 ? I18n.getLabel("prompt.text.validation.minimum-length", this.minimumLength) + ". " : "";
            String maximumLabel = this.maximumLength != null ? I18n.getLabel("prompt.text.validation.maximum-length", this.maximumLength) + "." : "";
            this.renderWithScale(poseStack, 0.5, () -> TextMultiLinePromptScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(minimumLabel + maximumLabel).trim(), (int)0, (int)0, (int)(this.inputIsValid ? GuiConstants.COLOR_STRONGER_RED : GuiConstants.COLOR_WHITE)));
        }
    }

    @Override
    protected boolean isValid() {
        return this.inputIsValid;
    }

    public void m_7379_() {
        super.m_7379_();
        if (!this.inputIsValid || this.shouldSendCancel) {
            Network.sendToServer(new ServerBoundTextPromptResponsePacket(this.uuid, null));
        } else {
            Network.sendToServer(new ServerBoundTextPromptResponsePacket(this.uuid, this.textInputBox.getValue()));
        }
    }
}

