/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.provision;

import com.equestricraft.common.ECLevel;
import com.equestricraft.core.player.provision.PlayerProvisionItemInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.provision.ProvisionItemWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundGiveProvisionToHorsePacket;
import com.equestricraft.mod.packet.ServerBoundProvisionInventoryMenuOpenPacket;
import com.equestricraft.mod.packet.ServerBoundSetBucketContentsPacket;
import com.equestricraft.mod.provision.ProvisionInventoryPage;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ProvisionInventoryMenu
extends PageScreen<ProvisionInventoryPage, PlayerProvisionItemInfo, Object, Object> {
    private final Integer horseId;
    private final int provisionId;
    private final Integer containerEntityId;
    private final ECLevel level;

    public static void showMenu(Integer horseId, int provisionId, String name, ProvisionInventoryPage page, Integer containerEntityId, ECLevel level) {
        ProvisionInventoryMenu screen = new ProvisionInventoryMenu(horseId, provisionId, name, page, containerEntityId, level);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected ProvisionInventoryMenu(Integer horseId, int provisionId, String name, ProvisionInventoryPage page, Integer containerEntityId, ECLevel level) {
        super(name, page);
        this.horseId = horseId;
        this.provisionId = provisionId;
        this.containerEntityId = containerEntityId;
        this.level = level;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = 20;
        int y = 35;
        int widthPerItem = (this.f_96543_ - 20) / 3;
        int countOnRow = 0;
        for (PlayerProvisionItemInfo item : ((ProvisionInventoryPage)this.page).getItems()) {
            ProvisionItemWidget widget = new ProvisionItemWidget(x, y, widthPerItem, item, this::onSelect);
            this.m_142416_((GuiEventListener)widget);
            x += widthPerItem;
            if (++countOnRow < 3) continue;
            countOnRow = 0;
            x = 20;
            y += GuiUtil.getSpacedLineHeight() * 3;
        }
    }

    private void onSelect(PlayerProvisionItemInfo item) {
        this.m_7379_();
        Object packet = this.containerEntityId != null ? new ServerBoundSetBucketContentsPacket(this.containerEntityId, this.level, item.uuid()) : new ServerBoundGiveProvisionToHorsePacket(item.uuid(), this.horseId);
        Network.sendToServer(packet);
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundProvisionInventoryMenuOpenPacket packet = new ServerBoundProvisionInventoryMenuOpenPacket(this.horseId, this.provisionId, newPageNumber, this.containerEntityId);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ProvisionInventoryMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

