/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.provision;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.provision.ProvisionTypeInventoryDetails;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.provision.ProvisionItemTypeWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundProvisionInventoryMenuOpenPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ProvisionItemTypeListMenu
extends Screen {
    private final Integer horseId;
    private final Integer containerEntityId;
    private final List<ProvisionTypeInventoryDetails> details;
    private int scroll = 0;
    private int totalHeight;
    private final List<ProvisionItemTypeWidget> widgets = new ArrayList<ProvisionItemTypeWidget>(0);

    public static void showScreen(Integer horseId, Integer containerEntityId, List<ProvisionTypeInventoryDetails> details) {
        ProvisionItemTypeListMenu screen = new ProvisionItemTypeListMenu(horseId, containerEntityId, details);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private ProvisionItemTypeListMenu(Integer horseId, Integer containerEntityId, List<ProvisionTypeInventoryDetails> details) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("provision.inventory.menu.title")));
        this.horseId = horseId;
        this.containerEntityId = containerEntityId;
        this.details = details;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ProvisionItemTypeListMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        int y = 35;
        int widgetWidth = this.f_96543_ - 40;
        this.widgets.clear();
        for (ProvisionTypeInventoryDetails detail : this.details) {
            ProvisionItemTypeWidget widget = new ProvisionItemTypeWidget(20, y + this.scroll, widgetWidth, detail, this::onClick);
            widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
            this.widgets.add(widget);
            y += widget.m_93694_() + 10;
        }
        this.totalHeight = y;
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void onClick(ProvisionTypeInventoryDetails details) {
        ServerBoundProvisionInventoryMenuOpenPacket packet = new ServerBoundProvisionInventoryMenuOpenPacket(this.horseId, details.provision().id(), 1, this.containerEntityId);
        Network.sendToServer(packet);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        double newVal = (double)this.scroll + scroll * 12.0;
        if (newVal > 0.0) {
            newVal = 0.0;
        } else {
            double limit = (double)this.totalHeight - (double)this.f_96544_ / 2.0 + 10.0;
            if (Math.abs(newVal) > limit) {
                newVal = -limit;
            }
        }
        this.scroll = (int)newVal;
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int action) {
        for (ProvisionItemTypeWidget widget : this.widgets) {
            if (!widget.m_6375_(mouseX, mouseY, action)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, action);
    }
}

