/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.provision;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.provision.ProvisionTypeInventoryDetails;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class ProvisionItemTypeWidget
extends ECWidget {
    private final ProvisionTypeInventoryDetails provision;
    private final ECField nameField;
    private final ECField quantityField;
    private final ECMultiLineField descriptionField;
    private final Consumer<ProvisionTypeInventoryDetails> onClick;

    protected ProvisionItemTypeWidget(int x, int y, int width, ProvisionTypeInventoryDetails details, Consumer<ProvisionTypeInventoryDetails> onClick) {
        super(x, y, width, 0);
        this.provision = details;
        this.onClick = onClick;
        int currentY = 0;
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(currentY), width).withValue(details.provision().name()).complete();
        this.quantityField = ECField.Builder.start(this.dx(width), this.dy(currentY), width).withValue(this.buildQuantityLabel()).rightAligned().complete();
        this.descriptionField = ECMultiLineField.Builder.start().withWidth(width).withLabel(details.provision().description()).withPosition(this.dx(0), this.dy(currentY += this.nameField.m_93694_())).complete();
        this.setHeight(currentY += this.descriptionField.getHeight());
    }

    private String buildQuantityLabel() {
        if (this.provision.expiredQuantity() > 0.0) {
            return this.provision.quantity() + " (" + I18n.getLabel("provision.inventory.menu.expired-label", this.provision.expiredQuantity()) + ")";
        }
        return "" + this.provision.quantity();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.isWithin(mouseX, mouseY)) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(-2), this.dy(-2), this.f_93618_ + 2, this.f_93619_ + 2, Argb.ARGB_WHITE.withTransparency(50));
        }
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.quantityField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.descriptionField.render(poseStack);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        this.onClick.accept(this.provision);
        return true;
    }
}

