/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.provision;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.provision.PlayerProvisionItemInfo;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class ProvisionItemWidget
extends ECWidget {
    private final PlayerProvisionItemInfo item;
    private final ECField unitsLeftLabel;
    private final ECField daysUntilExpiryLabel;
    private final Consumer<PlayerProvisionItemInfo> onClick;

    protected ProvisionItemWidget(int x, int y, int width, PlayerProvisionItemInfo item, Consumer<PlayerProvisionItemInfo> onClick) {
        super(x, y, width, 0);
        this.item = item;
        this.unitsLeftLabel = ECField.Builder.start(this.dx(0), this.dy(0), width).withLabel(I18n.getLabel("provision.inventory.menu.item.field.units-left.label")).withValue(item.unitsRemaining()).complete();
        this.daysUntilExpiryLabel = this.buildExpiryLabel();
        this.onClick = onClick;
        this.setHeight(30);
    }

    private ECField buildExpiryLabel() {
        if (this.item.daysUntilExpiry() != null) {
            ECField.Builder builder = ECField.Builder.start(this.dx(0), this.dy(15), this.f_93618_);
            if (this.item.daysUntilExpiry() >= 0) {
                builder.withLabel(I18n.getLabel("provision.inventory.menu.item.field.days-until-expiry.label")).withValue(this.item.daysUntilExpiry());
            } else {
                builder.withValue(I18n.getLabel("provision.inventory.menu.expired")).withValueColor(Argb.ARGB_RED);
            }
            return builder.complete();
        }
        return null;
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        this.onClick.accept(this.item);
        return true;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.isWithin(mouseX, mouseY)) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, Argb.ARGB_WHITE.withTransparency(50));
        }
        this.unitsLeftLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.daysUntilExpiryLabel != null) {
            this.daysUntilExpiryLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }
}

