/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.quest;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.quest.menu.QuestProgressMenuInfo;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.quest.QuestObjectivesList;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundQuestAbandonPacket;
import com.equestricraft.mod.packet.ServerBoundQuestPausePacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CurrentQuestScreen
extends Screen {
    private final QuestProgressMenuInfo questProgressMenuInfo;
    private ECMultiLineField descriptionLabel = null;
    private final TextComponent objectivesHeader = ComponentUtil.buildColoredTextComponent(I18n.getLabel("quest.current-quest-menu.header.objectives.label"));
    private QuestObjectivesList objectivesList = null;
    private static final int X_MARGIN = 20;

    public static void showScreen(QuestProgressMenuInfo questProgressMenuInfo) {
        CurrentQuestScreen screen = new CurrentQuestScreen(questProgressMenuInfo);
        ScreenStack.getInstance().push(screen);
    }

    protected CurrentQuestScreen(QuestProgressMenuInfo questProgressMenuInfo) {
        super((Component)ComponentUtil.buildColoredTextComponent(questProgressMenuInfo.name()));
        this.questProgressMenuInfo = questProgressMenuInfo;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(this.questProgressMenuInfo.description()).withWidth(this.f_96543_ - 40).withPosition(20, 10 + GuiUtil.getSpacedLineHeight() + 2).complete();
        int y = 10 + GuiUtil.getSpacedLineHeight() + this.descriptionLabel.getHeight() + 10 + GuiUtil.getSpacedLineHeight() + 4;
        this.objectivesList = new QuestObjectivesList(20, y, this.f_96543_ - 40, this.f_96544_ - (y + 30), this.questProgressMenuInfo.objectives());
        this.m_142416_((GuiEventListener)this.objectivesList);
        this.renderButtons();
    }

    private void renderButtons() {
        ECButton abandonButton = ECButton.Builder.start(20, this.f_96544_ - 30, 80, 20).withLabel(I18n.getLabel("quest.current-quest.menu.button.abandon.label")).withOnClick(() -> Network.sendToServer(new ServerBoundQuestAbandonPacket())).complete();
        this.m_142416_((GuiEventListener)abandonButton);
        if (this.questProgressMenuInfo.canPause()) {
            ECButton pauseButton = ECButton.Builder.start(105, this.f_96544_ - 30, 80, 20).withLabel(I18n.getLabel("quest.current-quest-menu.button.pause.label")).withOnClick(() -> Network.sendToServer(new ServerBoundQuestPausePacket())).complete();
            this.m_142416_((GuiEventListener)pauseButton);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        int lineHeight = GuiUtil.getSpacedLineHeight();
        CurrentQuestScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)20, (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.descriptionLabel.render(poseStack);
        int y = 10 + lineHeight + this.descriptionLabel.getHeight();
        GuiUtil.drawHorizontalLine(poseStack, 20, this.f_96543_ - 20, y + 2, 1, Argb.ARGB_MC_AQUA);
        CurrentQuestScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.objectivesHeader, (int)20, (int)(y + 10), (int)GuiConstants.COLOR_WINDOW_TITLE_SECONDARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.objectivesList.m_6050_(mouseX, mouseY, scroll);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

