/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.quest;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.quest.menu.QuestInProgressMenuItem;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.quest.QuestProgressListWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundQuestSetTrackedPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class QuestInProgressMenuScreen
extends Screen {
    private final List<QuestInProgressMenuItem> inProgressQuests;
    private QuestProgressListWidget questProgressListWidget;
    private final TextComponent noInProgressQuestsLabel = ComponentUtil.buildColoredTextComponent(I18n.getLabel("quest.in-progress-menu.no-quests"));
    private final boolean showNoneInProgressLabel;

    public static void showScreen(List<QuestInProgressMenuItem> inProgressQuests) {
        QuestInProgressMenuScreen screen = new QuestInProgressMenuScreen(inProgressQuests);
        ScreenStack.getInstance().push(screen);
    }

    private QuestInProgressMenuScreen(List<QuestInProgressMenuItem> inProgressQuests) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("quest.in-progress-menu.title")));
        this.inProgressQuests = inProgressQuests;
        this.showNoneInProgressLabel = inProgressQuests.isEmpty();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        this.questProgressListWidget = new QuestProgressListWidget(10, 25, this.f_96543_ - 20, this.f_96544_ - 35, this.inProgressQuests, this::onClick);
        this.m_142416_((GuiEventListener)this.questProgressListWidget);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        QuestInProgressMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        if (this.showNoneInProgressLabel) {
            QuestInProgressMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.noInProgressQuestsLabel, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)GuiConstants.COLOR_WHITE);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void onClick(QuestInProgressMenuItem q) {
        super.m_7379_();
        ServerBoundQuestSetTrackedPacket packet = new ServerBoundQuestSetTrackedPacket(q.getId());
        Network.sendToServer(packet);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.questProgressListWidget.m_6050_(mouseX, mouseY, scroll) || super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int action) {
        return this.questProgressListWidget.m_6375_(mouseX, mouseY, action) || super.m_6375_(mouseX, mouseY, action);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

