/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.quest;

import com.equestricraft.common.QuestType;
import com.equestricraft.core.quest.menu.QuestMenuItem;
import com.equestricraft.core.quest.menu.QuestSingleMenuItem;
import com.equestricraft.core.quest.menu.QuestStoryGroupMenuItem;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.quest.QuestItemListWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundQuestGroupMenuRequestPacket;
import com.equestricraft.mod.packet.ServerBoundQuestStartPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class QuestItemScreen
extends Screen {
    private final QuestType questType;
    private final List<QuestMenuItem> questMenuItems;
    private QuestItemListWidget questItemListWidget;

    public static void showScreen(String menuTitle, QuestType questType, List<QuestMenuItem> questMenuItems) {
        QuestItemScreen screen = new QuestItemScreen(menuTitle, questType, questMenuItems);
        ScreenStack.getInstance().push(screen);
    }

    private QuestItemScreen(String menuTitle, QuestType questType, List<QuestMenuItem> questMenuItems) {
        super((Component)ComponentUtil.buildColoredTextComponent(menuTitle));
        this.questType = questType;
        this.questMenuItems = questMenuItems;
    }

    protected void m_7856_() {
        this.questItemListWidget = new QuestItemListWidget(10, 30, this.f_96543_ - 20, this.f_96544_ - 40, this.questMenuItems, this::onItemClick);
        this.m_142416_((GuiEventListener)this.questItemListWidget);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        QuestItemScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void onItemClick(QuestMenuItem item) {
        if (item instanceof QuestStoryGroupMenuItem) {
            QuestStoryGroupMenuItem questStoryGroupMenuItem = (QuestStoryGroupMenuItem)item;
            this.onQuestGroupClick(questStoryGroupMenuItem);
        } else if (item instanceof QuestSingleMenuItem) {
            QuestSingleMenuItem questSingleMenuItem = (QuestSingleMenuItem)item;
            this.onQuestSingleClick(questSingleMenuItem);
        } else {
            throw new IllegalArgumentException(String.format("Invalid quest item: %s", item.getClass().getName()));
        }
    }

    private void onQuestGroupClick(QuestStoryGroupMenuItem questStoryGroupMenuItem) {
        ServerBoundQuestGroupMenuRequestPacket packet = new ServerBoundQuestGroupMenuRequestPacket(questStoryGroupMenuItem.getId(), this.questType);
        Network.sendToServer(packet);
    }

    private void onQuestSingleClick(QuestSingleMenuItem questSingleMenuItem) {
        ScreenStack.getInstance().clear();
        this.m_7379_();
        ServerBoundQuestStartPacket packet = new ServerBoundQuestStartPacket(questSingleMenuItem.getId(), questSingleMenuItem.getStartElementId());
        Network.sendToServer(packet);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.questItemListWidget.m_6050_(mouseX, mouseY, scroll) || super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int action) {
        return this.questItemListWidget.m_6375_(mouseX, mouseY, action) || super.m_6375_(mouseX, mouseY, action);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

