/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.quest;

import com.equestricraft.common.Argb;
import com.equestricraft.common.NumberFormatter;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.quest.menu.QuestMenuItem;
import com.equestricraft.core.quest.menu.QuestSingleMenuItem;
import com.equestricraft.core.quest.menu.QuestStoryGroupMenuItem;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class QuestItemWidget
extends ECWidget {
    private final QuestMenuItem questMenuItem;
    private final TextComponent titleComponent;
    private final ECMultiLineField descriptionLabel;
    private final ECField completionPercentageLabel;
    private final Consumer<QuestMenuItem> onClick;
    private static final ResourceLocation toolsIcon = Resources.getTextures().getGui().get("tools.png");
    private static final ResourceLocation greenTickIcon = Resources.getTextures().getGui().get("green-tick.png");

    public QuestItemWidget(int x, int y, int width, QuestMenuItem questMenuItem, Consumer<QuestMenuItem> onClick) {
        super(x, y, width, 0);
        this.questMenuItem = questMenuItem;
        this.onClick = onClick;
        this.titleComponent = ComponentUtil.buildColoredTextComponent(questMenuItem.getTitle());
        this.titleComponent.m_6270_(this.titleComponent.m_7383_().m_131162_(Boolean.valueOf(true)));
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(questMenuItem.getDescription()).withWidth(width).complete();
        int height = 15;
        if (questMenuItem instanceof QuestStoryGroupMenuItem) {
            QuestStoryGroupMenuItem questStoryGroupMenuItem = (QuestStoryGroupMenuItem)questMenuItem;
            if (questStoryGroupMenuItem.getCompletionPercentage() != null) {
                this.completionPercentageLabel = ECField.Builder.start(this.dx(0), this.dy(15), width).withLabel(I18n.getLabel("quest.menu.item.field.completion-percentage.label")).withValue(NumberFormatter.format2DP(questStoryGroupMenuItem.getCompletionPercentage()) + "%").complete();
                height += 15;
            } else {
                this.completionPercentageLabel = null;
            }
        } else if (questMenuItem instanceof QuestSingleMenuItem) {
            QuestSingleMenuItem singleMenuItem = (QuestSingleMenuItem)questMenuItem;
            this.completionPercentageLabel = null;
            if (singleMenuItem.getMoneyReward() != null || singleMenuItem.getXpReward() > 0) {
                height += GuiUtil.getStandardLineHeight();
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid item type: %s", questMenuItem.getClass().getName()));
        }
        this.setHeight((height += this.descriptionLabel.getHeight()) + 5);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.isWithin(mouseX, mouseY)) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(-2), this.dy(-2), this.f_93618_ + 2, this.f_93619_ + 2, Argb.ARGB_WHITE.withTransparency(50));
        }
        int currentY = 0;
        QuestItemWidget.m_93243_((PoseStack)poseStack, (Font)this.getFont(), (Component)this.titleComponent, (int)this.dx(0), (int)this.dy(currentY), (int)GuiConstants.COLOR_WINDOW_TITLE_SECONDARY);
        currentY += 15;
        if (this.completionPercentageLabel != null) {
            this.completionPercentageLabel.f_93620_ = this.dx(0);
            this.completionPercentageLabel.f_93621_ = this.dy(15);
            this.completionPercentageLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
            currentY += 15;
        }
        this.descriptionLabel.position(this.dx(0), this.dy(currentY)).render(poseStack);
        currentY += this.descriptionLabel.getHeight() + 4;
        int iconSize = GuiUtil.getStandardLineHeight() + 2;
        QuestMenuItem questMenuItem = this.questMenuItem;
        if (questMenuItem instanceof QuestStoryGroupMenuItem) {
            QuestStoryGroupMenuItem groupMenuItem = (QuestStoryGroupMenuItem)questMenuItem;
            if (groupMenuItem.getCompletionPercentage() != null && groupMenuItem.getCompletionPercentage() >= 100.0) {
                GuiUtil.drawImage(poseStack, greenTickIcon, this.dx(this.f_93618_ - iconSize), this.dy(0), iconSize, iconSize);
            }
        } else {
            questMenuItem = this.questMenuItem;
            if (questMenuItem instanceof QuestSingleMenuItem) {
                QuestSingleMenuItem singleMenuItem = (QuestSingleMenuItem)questMenuItem;
                if (singleMenuItem.isNotLive()) {
                    GuiUtil.drawImage(poseStack, toolsIcon, this.dx(this.f_93618_ - iconSize), this.dy(0), iconSize, iconSize);
                } else if (singleMenuItem.isCompleted()) {
                    GuiUtil.drawImage(poseStack, greenTickIcon, this.dx(this.f_93618_ - iconSize), this.dy(0), iconSize, iconSize);
                }
                int rewardX = 0;
                if (singleMenuItem.getMoneyReward() != null) {
                    QuestItemWidget.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)singleMenuItem.getMoneyReward(), (int)this.dx(rewardX), (int)this.dy(currentY), (int)GuiConstants.COLOR_GREEN);
                    rewardX += this.getFont().m_92895_(singleMenuItem.getMoneyReward()) + 10;
                }
                if (singleMenuItem.getXpReward() > 0) {
                    QuestItemWidget.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)(singleMenuItem.getXpReward() + "xp"), (int)this.dx(rewardX), (int)this.dy(currentY), (int)GuiConstants.COLOR_GREEN);
                }
            }
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        QuestSingleMenuItem singleMenuItem;
        QuestMenuItem questMenuItem = this.questMenuItem;
        if (questMenuItem instanceof QuestSingleMenuItem && ((singleMenuItem = (QuestSingleMenuItem)questMenuItem).getStartElementId() == null || !singleMenuItem.isCanStart())) {
            return false;
        }
        this.onClick.accept(this.questMenuItem);
        return true;
    }
}

