/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.shop;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.shop.ShopInfo;
import com.equestricraft.core.shop.item.ShopItemInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.shop.ShopItemListWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundShopItemBuyPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ShopItemMenuScreen
extends Screen {
    private final ShopInfo shop;
    private final List<ShopItemInfo> items;
    private ShopItemListWidget shopItemListWidget;
    private ECMultiLineField descriptionLabel = null;
    private int currentY = 0;

    public static void showScreen(ShopInfo shop, List<ShopItemInfo> items) {
        ShopItemMenuScreen screen = new ShopItemMenuScreen(shop, items);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private ShopItemMenuScreen(ShopInfo shop, List<ShopItemInfo> items) {
        super((Component)ComponentUtil.buildColoredTextComponent(shop.name()));
        this.shop = shop;
        this.items = items;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.descriptionLabel = ECMultiLineField.Builder.start().withWidth(this.f_96543_ - 20).withLabel(this.shop.description()).centerAlign().complete();
        this.currentY = 20 + this.descriptionLabel.getHeight() + 5;
        this.initHeader();
        this.shopItemListWidget = new ShopItemListWidget(10, this.currentY, this.f_96543_ - 20, this.f_96544_ - (this.currentY + 10), this.items, this::onItemClick);
    }

    private void initHeader() {
        ECField nameLabel = ECField.Builder.start(10, this.currentY, this.f_96543_).withValue(I18n.getLabel("shop.menu.header.name.label")).complete();
        this.m_142416_((GuiEventListener)nameLabel);
        ECField priceLabel = ECField.Builder.start(260, this.currentY, this.f_96543_).withValue(I18n.getLabel("shop.menu.header.price.label")).complete();
        this.m_142416_((GuiEventListener)priceLabel);
        this.currentY += nameLabel.m_93694_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ShopItemMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.descriptionLabel.position(this.f_96543_ / 2, 20).render(poseStack);
        this.shopItemListWidget.f_93621_ = this.currentY + GuiUtil.getSpacedLineHeight();
        this.shopItemListWidget.m_6305_(poseStack, mouseX, mouseY, partialTick);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void onItemClick(ShopItemInfo item) {
        ServerBoundShopItemBuyPacket packet = new ServerBoundShopItemBuyPacket(item.shopItemId());
        Network.sendToServer(packet);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.shopItemListWidget.m_6050_(mouseX, mouseY, scroll) || super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int partialTick) {
        return this.shopItemListWidget.m_6375_(mouseX, mouseY, partialTick) || super.m_6375_(mouseX, mouseY, partialTick);
    }
}

