/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.shop;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.shop.item.ShopItemInfo;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class ShopItemWidget
extends ECWidget {
    private final ECField nameField;
    private final ECField priceField;
    private final ECField outOfStockLabel;
    private final ECButton button;

    protected ShopItemWidget(int x, int y, int width, ShopItemInfo item, Consumer<ShopItemInfo> onClick) {
        super(x, y, width, GuiUtil.getSpacedLineHeight());
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(item.itemName()).withValueColor(Argb.ARGB_WHITE).complete();
        this.priceField = ECField.Builder.start(this.dx(250), this.dy(0), width).withValue(item.price()).withValueColor(Argb.ARGB_WHITE).complete();
        if (!item.inStock()) {
            this.outOfStockLabel = ECField.Builder.start(this.dx(width), this.dy(0), 100).withValue(I18n.getLabel("shop.menu.item.field.out-of-stock.label")).withValueColor(Argb.ARGB_RED).rightAligned().complete();
            this.button = null;
        } else {
            this.outOfStockLabel = null;
            this.button = ECButton.Builder.start(this.dx(width), this.dy(0), 100, GuiUtil.getSpacedLineHeight()).withLabel(I18n.getLabel("shop.menu.item.button.purchase.label")).withOnClick(() -> onClick.accept(item)).rightAligned().complete();
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return this.button != null && this.button.m_6375_(mouseX, mouseY, action);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.f_93621_ = this.dy(0);
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.priceField.f_93621_ = this.dy(0);
        this.priceField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.outOfStockLabel != null) {
            this.outOfStockLabel.f_93621_ = this.dy(0);
            this.outOfStockLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
        } else {
            this.button.f_93621_ = this.dy(0);
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }
}

