/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.studregister;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.stud.HorseStudRegisterSortOrder;
import com.equestricraft.core.horse.stud.StudRegistrationStatus;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundStudRegistrationListOpenRequestPacket;
import com.equestricraft.mod.packet.ServerBoundStudRegistrationRemovePacket;
import com.equestricraft.mod.packet.ServerBoundStudRegistrationRenewPacket;
import com.equestricraft.mod.packet.ServerBoundStudRegistrationRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseStudRegisterMenu
extends Screen {
    private final Integer horseId;
    private final int registryId;
    private final StudRegistrationStatus status;

    public static void showScreen(Integer horseId, int registryId, String name, StudRegistrationStatus status) {
        HorseStudRegisterMenu screen = new HorseStudRegisterMenu(horseId, registryId, name, status);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected HorseStudRegisterMenu(Integer horseId, int registryId, String name, StudRegistrationStatus status) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.stud-registry.menu.title", name)));
        this.horseId = horseId;
        this.registryId = registryId;
        this.status = status;
    }

    protected void m_7856_() {
        super.m_7856_();
        int y = 35;
        if (this.horseId != null && this.status != null) {
            if (this.status == StudRegistrationStatus.NONE) {
                ECButton registerButton = ECButton.Builder.start(this.f_96543_ / 2, y, 100, 20).withLabel(I18n.getLabel("horse.stud-registry.menu.button.register-horse.label")).withOnClick(() -> {
                    this.m_7379_();
                    ServerBoundStudRegistrationRequestPacket packet = new ServerBoundStudRegistrationRequestPacket(this.horseId, this.registryId);
                    Network.sendToServer(packet);
                }).centerAligned().complete();
                this.m_142416_((GuiEventListener)registerButton);
                y += 25;
            } else {
                ECField registeredComponent = ECField.Builder.start(this.f_96543_ / 2 - 50, y, 100).withLabel(I18n.getLabel("horse.stud-registry.menu.button.status.label")).withValue(this.status.getTranslatedName()).complete();
                this.m_142416_((GuiEventListener)registeredComponent);
                ECButton renewButton = ECButton.Builder.start(this.f_96543_ / 2, y += 25, 100, 20).withLabel(I18n.getLabel("horse.stud-registry.menu.button.renew-registration.label")).withOnClick(() -> {
                    this.m_7379_();
                    ServerBoundStudRegistrationRenewPacket packet = new ServerBoundStudRegistrationRenewPacket(this.horseId);
                    Network.sendToServer(packet);
                }).centerAligned().complete();
                this.m_142416_((GuiEventListener)renewButton);
                ECButton removeButton = ECButton.Builder.start(this.f_96543_ / 2, y += 25, 100, 20).withLabel(I18n.getLabel("horse.stud-registry.menu.button.remove-registration.label")).withOnClick(() -> {
                    this.m_7379_();
                    ServerBoundStudRegistrationRemovePacket packet = new ServerBoundStudRegistrationRemovePacket(this.horseId);
                    Network.sendToServer(packet);
                }).centerAligned().complete();
                this.m_142416_((GuiEventListener)removeButton);
                y += 25;
            }
        }
        ECButton viewRegisterButton = ECButton.Builder.start(this.f_96543_ / 2, y, 100, 20).withLabel(I18n.getLabel("horse.stud-registry.menu.button.view-register.label")).withOnClick(() -> {
            this.m_7379_();
            ServerBoundStudRegistrationListOpenRequestPacket packet = new ServerBoundStudRegistrationListOpenRequestPacket(this.registryId, HorseStudRegisterSortOrder.INITIAL_REGISTRATION, SortDirection.ASCENDING, 1);
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)viewRegisterButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseStudRegisterMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

