/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.studregister;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.stud.HorseStudRegisterPage;
import com.equestricraft.core.horse.stud.HorseStudRegisterSortOrder;
import com.equestricraft.core.horse.stud.StudRegisterEntry;
import com.equestricraft.core.studregistry.StudRegistrySimple;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.studregister.StudRegisterEntryCard;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundStudRegistrationListOpenRequestPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class StudRegisterListScreen
extends PageScreen<HorseStudRegisterPage, StudRegisterEntry, HorseStudRegisterSortOrder, Object> {
    private final StudRegistrySimple registry;

    public static void showScreen(StudRegistrySimple registry, HorseStudRegisterPage page) {
        StudRegisterListScreen screen = new StudRegisterListScreen(registry, page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private StudRegisterListScreen(StudRegistrySimple registry, HorseStudRegisterPage page) {
        super(I18n.getLabel("horse.stud-register-list.menu.title", registry.name()), page);
        this.registry = registry;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initItems();
        this.initSortTypeButtons();
        this.initSortOrderButtons();
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundStudRegistrationListOpenRequestPacket packet = new ServerBoundStudRegistrationListOpenRequestPacket(this.registry.id(), (HorseStudRegisterSortOrder)((Object)((HorseStudRegisterPage)this.page).getSortOrder()), ((HorseStudRegisterPage)this.page).getSortDirection(), newPageNumber);
        Network.sendToServer(packet);
    }

    private void initItems() {
        int x = 15;
        int y = 30;
        for (StudRegisterEntry item : ((HorseStudRegisterPage)this.page).getItems()) {
            StudRegisterEntryCard card = new StudRegisterEntryCard(x, y, 92, 80, item);
            if ((x += 100) + 100 > this.f_96543_) {
                x = 15;
                y += 85;
            }
            this.m_142416_((GuiEventListener)card);
        }
    }

    private void initSortTypeButtons() {
        ECButton.Builder button = ECButton.Builder.start(40, this.f_96544_ - 25, 100, 20);
        if (((HorseStudRegisterPage)this.page).getSortOrder() == HorseStudRegisterSortOrder.INITIAL_REGISTRATION) {
            button = button.withLabel(I18n.getLabel("horse.stud-register-list.menu.button.sort-last-renewal.label")).withOnClick(() -> {
                this.m_7379_();
                ServerBoundStudRegistrationListOpenRequestPacket packet = new ServerBoundStudRegistrationListOpenRequestPacket(this.registry.id(), HorseStudRegisterSortOrder.LAST_RENEWAL, ((HorseStudRegisterPage)this.page).getSortDirection(), ((HorseStudRegisterPage)this.page).getPageNumber());
                Network.sendToServer(packet);
            });
        } else if (((HorseStudRegisterPage)this.page).getSortOrder() == HorseStudRegisterSortOrder.LAST_RENEWAL) {
            button = button.withLabel(I18n.getLabel("horse.stud-register-list.menu.button.sort-expiry.label")).withOnClick(() -> {
                this.m_7379_();
                ServerBoundStudRegistrationListOpenRequestPacket packet = new ServerBoundStudRegistrationListOpenRequestPacket(this.registry.id(), HorseStudRegisterSortOrder.EXPIRY, ((HorseStudRegisterPage)this.page).getSortDirection(), ((HorseStudRegisterPage)this.page).getPageNumber());
                Network.sendToServer(packet);
            });
        } else if (((HorseStudRegisterPage)this.page).getSortOrder() == HorseStudRegisterSortOrder.EXPIRY) {
            button = button.withLabel(I18n.getLabel("horse.stud-register-list.menu.button.sort-initial-registration.label")).withOnClick(() -> {
                this.m_7379_();
                ServerBoundStudRegistrationListOpenRequestPacket packet = new ServerBoundStudRegistrationListOpenRequestPacket(this.registry.id(), HorseStudRegisterSortOrder.INITIAL_REGISTRATION, ((HorseStudRegisterPage)this.page).getSortDirection(), ((HorseStudRegisterPage)this.page).getPageNumber());
                Network.sendToServer(packet);
            });
        } else {
            return;
        }
        this.m_142416_((GuiEventListener)button.complete());
    }

    private void initSortOrderButtons() {
        ECButton.Builder button = ECButton.Builder.start(this.f_96543_ - 140, this.f_96544_ - 25, 100, 20);
        if (((HorseStudRegisterPage)this.page).getSortDirection() == SortDirection.ASCENDING) {
            button = button.withLabel(I18n.getLabel("horse.stud-register-list.menu.button.sort-descending.label")).withOnClick(() -> {
                this.m_7379_();
                ServerBoundStudRegistrationListOpenRequestPacket packet = new ServerBoundStudRegistrationListOpenRequestPacket(this.registry.id(), (HorseStudRegisterSortOrder)((Object)((Object)((HorseStudRegisterPage)this.page).getSortOrder())), SortDirection.DESCENDING, ((HorseStudRegisterPage)this.page).getPageNumber());
                Network.sendToServer(packet);
            });
        } else if (((HorseStudRegisterPage)this.page).getSortDirection() == SortDirection.DESCENDING) {
            button = button.withLabel(I18n.getLabel("horse.stud-register-list.menu.button.sort-ascending.label")).withOnClick(() -> {
                this.m_7379_();
                ServerBoundStudRegistrationListOpenRequestPacket packet = new ServerBoundStudRegistrationListOpenRequestPacket(this.registry.id(), (HorseStudRegisterSortOrder)((Object)((Object)((HorseStudRegisterPage)this.page).getSortOrder())), SortDirection.ASCENDING, ((HorseStudRegisterPage)this.page).getPageNumber());
                Network.sendToServer(packet);
            });
        } else {
            return;
        }
        this.m_142416_((GuiEventListener)button.complete());
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        StudRegisterListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

