/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.tack;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.tack.TackInventoryPage;
import com.equestricraft.core.player.tack.TackInventoryPageItem;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.tack.TackInventoryMenuWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundTackInventoryPageOpenPacket;
import com.equestricraft.mod.packet.ServerBoundTackInventorySelectPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class TackInventoryMenu
extends PageScreen<TackInventoryPage, TackInventoryPageItem, Object, Object> {
    private final int horseId;

    public static void showScreen(int horseId, TackInventoryPage page) {
        TackInventoryMenu screen = new TackInventoryMenu(horseId, page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected TackInventoryMenu(int horseId, TackInventoryPage page) {
        super(I18n.getLabel("tack.inventory.menu"), page);
        this.horseId = horseId;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initHeader();
        this.initRows();
    }

    private void initHeader() {
        int y = 30;
        ECField nameLabel = ECField.Builder.start(10, y, this.f_96543_).withValue(I18n.getLabel("tack.inventory.menu.header.name")).withValueColor(Argb.ARGB_WHITE).complete();
        this.m_142416_((GuiEventListener)nameLabel);
        ECField conditionLabel = ECField.Builder.start(this.f_96543_ - 60, y, this.f_96543_).withValue(I18n.getLabel("tack.inventory.menu.header.condition")).withValueColor(Argb.ARGB_WHITE).complete();
        this.m_142416_((GuiEventListener)conditionLabel);
    }

    private void initRows() {
        int x = 10;
        int y = 43;
        for (TackInventoryPageItem item : ((TackInventoryPage)this.page).getItems()) {
            TackInventoryMenuWidget row = new TackInventoryMenuWidget(x, y, this.f_96543_ - 20, item, this::onClick);
            y += row.m_93694_() + 2;
            this.m_142416_((GuiEventListener)row);
        }
    }

    private void onClick(TackInventoryPageItem item) {
        this.m_7379_();
        ServerBoundTackInventorySelectPacket packet = new ServerBoundTackInventorySelectPacket(this.horseId, item.itemId());
        Network.sendToServer(packet);
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundTackInventoryPageOpenPacket packet = new ServerBoundTackInventoryPageOpenPacket(this.horseId, newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        TackInventoryMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

