/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.tack;

import com.equestricraft.common.Argb;
import com.equestricraft.common.NumberFormatter;
import com.equestricraft.core.player.tack.TackInventoryPageItem;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class TackInventoryMenuWidget
extends ECWidget {
    private final TackInventoryPageItem item;
    private final ECField nameField;
    private final ECField conditionField;
    private final Consumer<TackInventoryPageItem> onClick;

    protected TackInventoryMenuWidget(int x, int y, int width, TackInventoryPageItem item, Consumer<TackInventoryPageItem> onClick) {
        super(x, y, width, GuiUtil.getSpacedLineHeight());
        this.item = item;
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(item.name()).complete();
        this.conditionField = ECField.Builder.start(this.dx(width - 50), this.dy(0), width).withValue(NumberFormatter.format2DP(item.condition())).complete();
        this.onClick = onClick;
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        this.onClick.accept(this.item);
        return true;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.isWithin(mouseX, mouseY)) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(-2), this.dy(-2), this.f_93618_ + 2, this.f_93619_ + 2, Argb.ARGB_WHITE.withTransparency(50));
        }
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.conditionField.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

