/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.university;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.university.degree.PlayerDegreeInfoDto;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UniversityDegreesScreen
extends Screen {
    private final List<PlayerDegreeInfoDto> playerDegreeInfoDtoList;

    public static void showScreen(List<PlayerDegreeInfoDto> playerDegreeInfoList) {
        UniversityDegreesScreen screen = new UniversityDegreesScreen(playerDegreeInfoList);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected UniversityDegreesScreen(List<PlayerDegreeInfoDto> playerDegreeInfoList) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("university.degrees-menu.title")));
        this.playerDegreeInfoDtoList = playerDegreeInfoList;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.renderList();
    }

    private void renderList() {
        int x = 20;
        int y = 60;
        for (PlayerDegreeInfoDto degree : this.playerDegreeInfoDtoList) {
            int width = this.f_96547_.m_92895_(degree.degreeName()) + 10;
            if (x > this.f_96543_ - (width + 5)) {
                x = 20;
                y += 25;
            }
            ECButton button = ECButton.Builder.start(x, y, width, 20).withLabel(degree.degreeName()).withOnClick(() -> ((UniversityDegreesScreen)this).m_7379_()).complete();
            x += width + 5;
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_6305_(PoseStack poseStack, int val1, int val2, float val3) {
        this.m_7333_(poseStack);
        UniversityDegreesScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, val1, val2, val3);
    }
}

