/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.university;

import com.equestricraft.core.university.module.questions.UniversityModuleQuestionDto;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.university.UniversityExamHandler;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UniversityExamQuestionScreen
extends Screen {
    private final UniversityExamHandler handler;
    private final UniversityModuleQuestionDto question;
    private ECMultiLineField questionComponent = null;

    public static void showExamQuestionScreen(String title, UniversityExamHandler handler, UniversityModuleQuestionDto question) {
        UniversityExamQuestionScreen prompt = new UniversityExamQuestionScreen(title, handler, question);
        Minecraft.m_91087_().m_91152_((Screen)prompt);
    }

    protected UniversityExamQuestionScreen(String title, UniversityExamHandler handler, UniversityModuleQuestionDto question) {
        super((Component)ComponentUtil.buildColoredTextComponent(title));
        this.handler = handler;
        this.question = question;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.questionComponent = ECMultiLineField.Builder.start().withLabel(this.question.questionText()).withWidth(this.f_96543_ - 50).withPosition(this.f_96543_ / 2, 40).centerAlign().complete();
        this.renderList();
    }

    private void renderList() {
        int x = 20;
        int y = 60;
        for (UniversityModuleQuestionDto.QuestionAnswer answer : this.question.questionAnswers()) {
            int width = this.f_96547_.m_92895_(answer.text()) + 10;
            if (x > this.f_96543_ - (width + 5)) {
                x = 20;
                y += 25;
            }
            ECButton button = ECButton.Builder.start(x, y, width, 20).withLabel(answer.text()).withOnClick(() -> {
                this.m_7379_();
                this.handler.questionAnswered(answer.correct());
            }).complete();
            x += width + 5;
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_6305_(PoseStack poseStack, int val1, int val2, float val3) {
        this.m_7333_(poseStack);
        UniversityExamQuestionScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.questionComponent.render(poseStack);
        super.m_6305_(poseStack, val1, val2, val3);
    }
}

