/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.weather;

import com.equestricraft.common.Argb;
import com.equestricraft.common.DateFormatter;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.weather.WeatherForecastInfo;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundWeatherForecastMenuOpenPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.equestricraft.mod.weather.WeatherForecastMenuPage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class WeatherForecastMenu
extends Screen {
    private final WeatherForecastMenuPage page;
    private ECMultiLineField descriptionLabel = null;
    List<String> iconsToShow = new ArrayList<String>();

    public static void showMenu(WeatherForecastMenuPage page) {
        WeatherForecastMenu screen = new WeatherForecastMenu(page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private WeatherForecastMenu(WeatherForecastMenuPage page) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("weather.forecast-menu.title", DateFormatter.formatDateDateMonthYear(page.date()))));
        this.page = page;
    }

    protected void m_7856_() {
        ECButton button;
        super.m_7856_();
        int xMargin = 10;
        int fieldWidth = this.f_96543_ - xMargin * 2;
        int y = 30;
        WeatherForecastInfo forecast = this.page.forecast();
        ECField temperatureField = ECField.Builder.start(xMargin, y, fieldWidth).withLabel(I18n.getLabel("weather.forecast-menu.field.temperature.label")).withValue(I18n.getLabel("weather.forecast-menu.field.temperature.value", forecast.minimumTemperatureFormatted(), forecast.maximumTemperatureFormatted())).complete();
        this.m_142416_((GuiEventListener)temperatureField);
        ECField windSpeedField = ECField.Builder.start(xMargin, y += 15, fieldWidth).withLabel(I18n.getLabel("weather.forecast-menu.field.wind-speed.label")).withValue(I18n.getLabel("weather.forecast-menu.field.wind-speed.value", forecast.minimumWindSpeedFormatted(), forecast.maximumWindSpeedFormatted())).complete();
        this.m_142416_((GuiEventListener)windSpeedField);
        y += 15;
        if (forecast.freezing()) {
            ECField freezingField = ECField.Builder.start(xMargin, y, fieldWidth).withLabel(I18n.getLabel("weather.forecast-menu.field.chance-of-freezing.label")).withValueColor(Argb.ARGB_BLUE).complete();
            this.m_142416_((GuiEventListener)freezingField);
            y += 15;
            this.iconsToShow.add("ice");
        }
        if (forecast.snowing()) {
            ECField snowField = ECField.Builder.start(xMargin, y, fieldWidth).withLabel(I18n.getLabel("weather.forecast-menu.field.chance-of-snow.label")).withValueColor(Argb.ARGB_WHITE).complete();
            this.m_142416_((GuiEventListener)snowField);
            y += 15;
            this.iconsToShow.add("snow");
        }
        if (forecast.thunder()) {
            ECField thunderField = ECField.Builder.start(xMargin, y, fieldWidth).withLabel(I18n.getLabel("weather.forecast-menu.field.chance-of-thunder.label")).withValueColor(Argb.ARGB_YELLOW).complete();
            this.m_142416_((GuiEventListener)thunderField);
            y += 15;
            this.iconsToShow.add("lightning");
        }
        if (forecast.heatwave()) {
            ECField heatwaveField = ECField.Builder.start(xMargin, y, fieldWidth).withLabel(I18n.getLabel("weather.forecast-menu.field.heatwave-warning.label")).withValueColor(Argb.ARGB_RED).complete();
            this.m_142416_((GuiEventListener)heatwaveField);
            y += 15;
            this.iconsToShow.add("thermometer");
        }
        if (forecast.highWinds()) {
            ECField highWindsField = ECField.Builder.start(xMargin, y, fieldWidth).withLabel(I18n.getLabel("weather.forecast-menu.field.high-winds-warning.label")).withValueColor(Argb.ARGB_MC_GRAY).complete();
            this.m_142416_((GuiEventListener)highWindsField);
            y += 15;
            this.iconsToShow.add("wind");
        }
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(this.page.description()).withPosition(10, y).withWidth(this.f_96543_ - xMargin * 2).complete();
        if (this.page.hasPrevious()) {
            button = ECButton.Builder.start(xMargin, this.f_96544_ - 25, 80, 20).withLabel(I18n.getLabel("weather.forecast-menu.button.previous-day.label")).withOnClick(() -> Network.sendToServer(new ServerBoundWeatherForecastMenuOpenPacket(this.page.currentOffset() - 1))).complete();
            this.m_142416_((GuiEventListener)button);
        }
        if (this.page.hasNext()) {
            button = ECButton.Builder.start(this.f_96543_ - xMargin - 80, this.f_96544_ - 25, 80, 20).withLabel(I18n.getLabel("weather.forecast-menu.button.next-day.label")).withOnClick(() -> Network.sendToServer(new ServerBoundWeatherForecastMenuOpenPacket(this.page.currentOffset() + 1))).complete();
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        WeatherForecastMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.descriptionLabel.render(poseStack);
        int imageY = this.descriptionLabel.getHeight() + 10;
        int currentImageX = 10;
        for (String icon : this.iconsToShow) {
            GuiUtil.drawImage(poseStack, Resources.getTextures().getGui().get(icon + ".png"), currentImageX, imageY, 20, 20);
            currentImageX += 25;
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

