/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.horse;

import com.equestricraft.core.horse.hoof.GroundType;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BlockGroundTypeMapper {
    private static final List<Block> hardBlocks = BlockGroundTypeMapper.buildHardBlocks();
    private static final List<Block> softBlocks = BlockGroundTypeMapper.buildSoftBlocks();
    private static final List<Block> looseBlocks = BlockGroundTypeMapper.buildLooseBlocks();

    private static List<Block> buildHardBlocks() {
        return List.of(Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_50638_, Blocks.f_50642_, Blocks.f_50639_, Blocks.f_50629_, Blocks.f_50632_, Blocks.f_50641_, Blocks.f_50652_, Blocks.f_50157_, Blocks.f_50079_, Blocks.f_50633_, Blocks.f_50062_, Blocks.f_50263_, Blocks.f_50394_, Blocks.f_50397_);
    }

    private static List<Block> buildSoftBlocks() {
        return List.of(Blocks.f_50493_, Blocks.f_50546_, Blocks.f_50599_, Blocks.f_50440_, Blocks.f_50195_);
    }

    private static List<Block> buildLooseBlocks() {
        return List.of(Blocks.f_49994_, Blocks.f_49992_, Blocks.f_49993_);
    }

    public static GroundType getType(Block block) {
        if (BlockGroundTypeMapper.isHard(block)) {
            return GroundType.HARD;
        }
        if (BlockGroundTypeMapper.isSoft(block)) {
            return GroundType.SOFT;
        }
        if (BlockGroundTypeMapper.isLoose(block)) {
            return GroundType.LOOSE;
        }
        return GroundType.SOFT;
    }

    public static boolean isHard(Block block) {
        return hardBlocks.contains(block);
    }

    public static boolean isSoft(Block block) {
        return softBlocks.contains(block);
    }

    public static boolean isLoose(Block block) {
        return looseBlocks.contains(block);
    }

    private BlockGroundTypeMapper() {
    }
}

