/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.horse;

import com.equestricraft.base.ClickType;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.common.EnvironmentType;
import com.equestricraft.common.HorseGaitVariant;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.tack.HorseBonnetModel;
import com.equestricraft.common.tack.HorseBootsModel;
import com.equestricraft.common.tack.HorseBridleModel;
import com.equestricraft.common.tack.HorseCinchModel;
import com.equestricraft.common.tack.HorseGirthModel;
import com.equestricraft.common.tack.HorseHalterModel;
import com.equestricraft.common.tack.HorsePadModel;
import com.equestricraft.common.tack.HorseReinModel;
import com.equestricraft.common.tack.HorseSaddleModel;
import com.equestricraft.common.tack.HorseWrapsModel;
import com.equestricraft.common.util.HorseHeightUtil;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.Gait;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseGait;
import com.equestricraft.core.horse.gait.HorseGaitCache;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.hoof.GroundType;
import com.equestricraft.core.horse.speed.HorseLeadDirection;
import com.equestricraft.core.horse.stats.HorseStat;
import com.equestricraft.mod.EntityInit;
import com.equestricraft.mod.client.ECNpc;
import com.equestricraft.mod.client.horse.BlockGroundTypeMapper;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.client.horse.visibilitypolicy.HorseVisibilityPolicy;
import com.equestricraft.mod.horse.HorseEventHandler;
import com.equestricraft.mod.horse.HorseFleeGoal;
import com.equestricraft.mod.horse.HorseFloatInWaterGoal;
import com.equestricraft.mod.horse.HorseFollowPlayerGoal;
import com.equestricraft.mod.horse.HorseFrustrationGoal;
import com.equestricraft.mod.horse.HorseGrazeGoal;
import com.equestricraft.mod.horse.HorseLookAtPlayerGoal;
import com.equestricraft.mod.horse.HorsePanicGoal;
import com.equestricraft.mod.horse.HorseRandomEjectGoal;
import com.equestricraft.mod.horse.HorseRandomWanderGoal;
import com.equestricraft.mod.horse.HorseRespondToCallGoal;
import com.equestricraft.mod.horse.HorseSlowDownStraightGoal;
import com.equestricraft.mod.horse.HorseWalkStraightGoal;
import com.equestricraft.mod.horse.HorseWanderToOtherHorseGoal;
import com.equestricraft.mod.horse.HorseWanderToParentGoal;
import com.equestricraft.mod.horse.HorseWanderToPlayerGoal;
import com.equestricraft.mod.horse.HorseWaypointFollowGoal;
import com.equestricraft.mod.horse.addpolicy.HorseAddPolicy;
import com.equestricraft.mod.horse.breeding.HorseFollowMateGoal;
import com.equestricraft.mod.horse.breeding.MareAcceptMateGoal;
import com.equestricraft.mod.horse.breeding.StallionFindMateGoal;
import com.equestricraft.mod.horse.feeding.HorseProvisionContainerConsumeGoal;
import com.equestricraft.mod.horse.grouprun.HorseFindRunningGroupGoal;
import com.equestricraft.mod.horse.grouprun.HorseRunInGroupGoal;
import com.equestricraft.mod.horse.idleaction.HorseIdleActionGoal;
import com.equestricraft.mod.horse.interactpolicy.HorseInteractPolicy;
import com.equestricraft.mod.horse.leashpolicy.HorseLeashPolicy;
import com.equestricraft.mod.horse.lunge.LungeAroundPlayerGoal;
import com.equestricraft.mod.horse.mountpolicy.HorseMountPolicy;
import com.equestricraft.mod.horse.removepolicy.HorseRemovePolicy;
import com.equestricraft.mod.horse.ride.HorseDismountAction;
import com.equestricraft.mod.horse.social.HorseFollowOtherHorseGoal;
import com.equestricraft.mod.horse.social.HorseInitiateHorsePlayGoal;
import com.equestricraft.mod.horse.social.HorsePlayActionGoal;
import com.equestricraft.mod.horse.speed.HorseSpeedDecreaseHandler;
import com.equestricraft.mod.horse.speed.policy.HorseSpeedControlPolicy;
import com.equestricraft.mod.horse.speedpolicy.HorseSpeedPolicy;
import com.equestricraft.mod.horse.tickpolicy.HorseServerTickPolicy;
import com.equestricraft.mod.horse.travelpolicy.HorseTravelPolicy;
import com.equestricraft.mod.npc.NpcFollowPlayerGoal;
import com.equestricraft.mod.util.AnimUtil;
import com.equestricraft.mod.util.ComponentUtil;
import com.equestricraft.mod.util.GoalUtil;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class EntityHorse
extends Animal
implements PlayerRideableJumping,
ECNpc {
    private static final EntityDataAccessor<String> horseType = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> internalId = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> colorName = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> patternNames = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> grayName = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> currentAnimation = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> gaitVariant = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> horseGait = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> leadDirection = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> maxHorseJump = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<CompoundTag> visibilitySettings = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<String> textureBase64 = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> gender = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> bonnetModel = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> bootsModel = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> bridleModel = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> cinchModel = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> girthModel = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> halterModel = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> padModel = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> reinModel = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> saddleModel = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> wrapsModel = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> idleAnimation = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> consumingFromProvisionContainer = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ageMonthsAtSpawn = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> modelScaleAtSpawn = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> maximumYRotation = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> maximumSideSteppingSpeed = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> currentGaitImpairmentFactor = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> hardTraction = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> softTraction = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> looseTraction = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> ownerId = SynchedEntityData.m_135353_(EntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String TAG_HORSE_TYPE = "horse_type";
    private static final String TAG_INTERNAL_ID = "internal_id";
    private static final String TAG_GAIT_VARIANT = "gait_variant";
    private static final String TAG_MAX_JUMP = "max_jump";
    private static final String TAG_VISIBILITY_SETTINGS = "visibility_settings";
    private static final String TAG_TEXTURE_BASE_64 = "texture_base_64";
    private float jumpTime;
    private float jumpPower = 0.5f;
    private float playerJumpPendingScale;
    private boolean isJumping;
    private boolean isJumpingPlayed;
    private boolean isEating;
    private int eatingCounter;
    private ChunkPos lastChunkPos;
    private boolean badRideEnd = false;
    private EntityHorse targetForBreeding = null;
    private float refTime = 0.0f;
    private boolean freeze = false;
    private HorseSpeedDecreaseHandler speedDecreaseHandler = null;
    private EQHorse horseData = null;
    private long lastSpeedIncreaseInput = 0L;
    private Vec3 currentVector = Vec3.f_82478_;
    private HorseVisibilityPolicy visibilityPolicy = null;
    private HorseInteractPolicy interactPolicy = null;
    private HorseAddPolicy addPolicy = null;
    private HorseRemovePolicy removePolicy = null;
    private HorseServerTickPolicy serverTickPolicy = null;
    private HorseSpeedPolicy speedPolicy = null;
    private HorseTravelPolicy travelPolicy = null;
    private HorseMountPolicy mountPolicy = null;
    private HorseLeashPolicy leashPolicy = null;
    private HorseSpeedControlPolicy speedControlPolicy = null;

    public EntityHorse(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.0f;
        this.m_6210_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HorseWalkStraightGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HorseFloatInWaterGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new HorseFrustrationGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new HorsePanicGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new HorseFleeGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new NpcFollowPlayerGoal(this));
        this.f_21345_.m_25352_(11, (Goal)new HorseRespondToCallGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new HorseRandomEjectGoal(this));
        this.f_21345_.m_25352_(25, (Goal)new HorsePlayActionGoal(this));
        this.f_21345_.m_25352_(35, (Goal)new HorseInitiateHorsePlayGoal(this));
        this.f_21345_.m_25352_(35, (Goal)new HorseRunInGroupGoal(this));
        this.f_21345_.m_25352_(25, (Goal)new HorseFindRunningGroupGoal(this));
        this.f_21345_.m_25352_(35, (Goal)new HorseFollowOtherHorseGoal(this));
        this.f_21345_.m_25352_(20, (Goal)new HorseWaypointFollowGoal(this));
        this.f_21345_.m_25352_(20, (Goal)new HorseFollowPlayerGoal(this));
        this.f_21345_.m_25352_(20, (Goal)new LungeAroundPlayerGoal(this));
        this.f_21345_.m_25352_(30, (Goal)new HorseProvisionContainerConsumeGoal(this));
        this.f_21345_.m_25352_(31, (Goal)new HorseGrazeGoal(this));
        this.f_21345_.m_25352_(40, (Goal)new MareAcceptMateGoal(this));
        this.f_21345_.m_25352_(40, (Goal)new StallionFindMateGoal(this));
        this.f_21345_.m_25352_(40, (Goal)new HorseFollowMateGoal(this));
        this.f_21345_.m_25352_(50, (Goal)new HorseWanderToParentGoal(this));
        this.f_21345_.m_25352_(55, (Goal)new HorseRandomWanderGoal(this));
        this.f_21345_.m_25352_(55, (Goal)new HorseWanderToPlayerGoal(this));
        this.f_21345_.m_25352_(60, (Goal)new HorseSlowDownStraightGoal(this));
        this.f_21345_.m_25352_(65, (Goal)new HorseLookAtPlayerGoal(this));
        this.f_21345_.m_25352_(75, (Goal)new HorseWanderToOtherHorseGoal(this));
        this.f_21345_.m_25352_(100, (Goal)new HorseIdleActionGoal(this));
        this.f_21345_.m_25352_(101, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 53.0).m_22268_(Attributes.f_22279_, 0.5).m_22266_(Attributes.f_22288_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(horseType, (Object)HorseEntityType.STANDARD.name());
        this.f_19804_.m_135372_(internalId, (Object)0);
        this.f_19804_.m_135372_(colorName, (Object)"white");
        this.f_19804_.m_135372_(patternNames, (Object)"");
        this.f_19804_.m_135372_(grayName, (Object)"");
        this.f_19804_.m_135372_(currentAnimation, (Object)"WALK_STANDARD");
        this.f_19804_.m_135372_(gaitVariant, (Object)HorseGaitVariant.STANDARD.name());
        this.f_19804_.m_135372_(horseGait, (Object)Halt.DEFAULT.getGaitType().name());
        this.f_19804_.m_135372_(leadDirection, (Object)HorseLeadDirection.LEFT.name());
        this.f_19804_.m_135372_(maxHorseJump, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(visibilitySettings, (Object)this.createDefaultTag());
        this.f_19804_.m_135372_(textureBase64, (Object)"");
        this.f_19804_.m_135372_(gender, (Object)HorseGender.STALLION.name());
        this.f_19804_.m_135372_(bonnetModel, (Object)"");
        this.f_19804_.m_135372_(bootsModel, (Object)"");
        this.f_19804_.m_135372_(bridleModel, (Object)"");
        this.f_19804_.m_135372_(cinchModel, (Object)"");
        this.f_19804_.m_135372_(girthModel, (Object)"");
        this.f_19804_.m_135372_(halterModel, (Object)"");
        this.f_19804_.m_135372_(padModel, (Object)"");
        this.f_19804_.m_135372_(reinModel, (Object)"");
        this.f_19804_.m_135372_(saddleModel, (Object)"");
        this.f_19804_.m_135372_(wrapsModel, (Object)"");
        this.f_19804_.m_135372_(idleAnimation, (Object)"RESTING_1");
        this.f_19804_.m_135372_(consumingFromProvisionContainer, (Object)false);
        this.f_19804_.m_135372_(ageMonthsAtSpawn, (Object)24);
        this.f_19804_.m_135372_(modelScaleAtSpawn, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(maximumYRotation, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(maximumSideSteppingSpeed, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(currentGaitImpairmentFactor, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(hardTraction, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(softTraction, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(looseTraction, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(ownerId, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128359_(TAG_HORSE_TYPE, this.getHorseEntityType().name());
        tag.m_128405_(TAG_INTERNAL_ID, this.getInternalId());
        tag.m_128359_(TAG_GAIT_VARIANT, this.getGaitVariant().name());
        tag.m_128350_(TAG_MAX_JUMP, this.getMaxHorseJump());
        tag.m_128365_(TAG_VISIBILITY_SETTINGS, (Tag)this.getVisibilitySettingsTag());
        tag.m_128359_(TAG_TEXTURE_BASE_64, this.getTextureBase64());
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setHorseEntityType(HorseEntityType.valueOf(tag.m_128461_(TAG_HORSE_TYPE)));
        this.setInternalId(tag.m_128451_(TAG_INTERNAL_ID));
        this.setGaitVariant(HorseGaitVariant.valueOf(tag.m_128461_(TAG_GAIT_VARIANT)));
        this.setMaxHorseJump(tag.m_128457_(TAG_MAX_JUMP));
        this.setVisibilitySettingsTag(tag.m_128469_(TAG_VISIBILITY_SETTINGS));
        this.setTextureBase64(tag.m_128461_(TAG_TEXTURE_BASE_64));
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)(this.getModelScaleAtSpawn() * 2.0f), (float)(this.getModelScaleAtSpawn() * 2.0f));
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob parent) {
        return (AgeableMob)((EntityType)EntityInit.HORSE_ENTITY.get()).m_20615_((Level)level);
    }

    public boolean m_5807_() {
        return this.m_6688_() instanceof LivingEntity;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    public boolean m_7132_() {
        return this.m_146862_(Player.class::isInstance);
    }

    public void m_7199_(int val) {
        this.f_19804_.m_135381_(currentAnimation, (Object)"REAR");
    }

    public void m_8012_() {
    }

    public boolean m_6147_() {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.95f;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    protected void m_7880_(float distance) {
        if (distance > 6.0f && this.isEating()) {
            this.setEating(false);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            this.getServerTickPolicy().onTick(this);
            if (!this.isJumping()) {
                this.setCurrentAnimation(this.getAnimationName());
            }
            ChunkPos currentChunkPos = this.m_146902_();
            if (this.lastChunkPos == null || !this.lastChunkPos.equals((Object)currentChunkPos)) {
                this.onChangedChunk();
                this.lastChunkPos = currentChunkPos;
            }
        }
        super.m_8119_();
    }

    private String getAnimationName() {
        if (this.isConsumingFromProvisionContainer()) {
            return "GRAZING_1";
        }
        if (this.isMoving()) {
            HorseSubGait subGait = this.getGait();
            HorseGait gait = subGait.getMainGait();
            Object name = gait.getAnimationName();
            if (gait.hasVariant()) {
                name = (String)name + "_" + this.getGaitVariant().name();
            }
            if (subGait.getMainGait().hasLeadSelection()) {
                name = (String)name + "_" + this.getLeadDirection().name();
            }
            return ((String)name).toUpperCase();
        }
        return this.getIdleAnimation();
    }

    private boolean isMoving() {
        return !this.currentVector.equals((Object)Vec3.f_82478_);
    }

    private String getIdleAnimation() {
        return (String)this.f_19804_.m_135370_(idleAnimation);
    }

    public void setIdleAnimation(String animation) {
        this.f_19804_.m_135381_(idleAnimation, (Object)animation);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (this.f_19796_.nextInt(900) == 0 && this.f_20919_ == 0) {
                this.m_5634_(1.0f);
            }
            if (this.canEatGrass()) {
                if (!this.isEating() && !this.m_20160_() && this.f_19796_.nextInt(300) == 0 && this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60713_(Blocks.f_50440_)) {
                    this.setEating(true);
                }
                if (this.isEating() && ++this.eatingCounter > 50) {
                    this.eatingCounter = 0;
                    this.setEating(false);
                }
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        this.freeze = false;
        if (!this.f_19853_.f_46443_) {
            this.getInteractPolicy().onHorseInteract(this, (ServerPlayer)player, ClickType.RIGHT, player.m_6144_());
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    protected void m_6119_() {
        if (!this.getLungeGoal().isLunging()) {
            super.m_6119_();
        }
    }

    public void m_21463_(Entity entity, boolean leashed) {
        this.freeze = false;
        if (!this.f_19853_.f_46443_) {
            boolean cancelled = HorseEventHandler.getInstance().fireLeashPutEvent(this, entity);
            if (!cancelled) {
                super.m_21463_(entity, leashed);
            }
        } else {
            super.m_21463_(entity, leashed);
        }
    }

    public void m_21455_(boolean val1, boolean val2) {
        this.freeze = false;
        if (!this.f_19853_.f_46443_) {
            boolean cancelled = HorseEventHandler.getInstance().fireLeashDropEvent(this);
            if (!cancelled) {
                super.m_21455_(val1, val2);
            }
        } else {
            super.m_21455_(val1, val2);
        }
    }

    protected void m_20351_(Entity entity) {
        this.freeze = false;
        if (!this.f_19853_.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            TaskScheduler.executeAsyncTask(() -> HorseEventHandler.getInstance().fireHorseDismounted(this, (ServerPlayer)player));
            if (this.horseData != null) {
                TaskScheduler.executeAsyncTask(() -> this.horseData.getActions().processAction(new HorseDismountAction(this.horseData)));
            }
        }
        super.m_20351_(entity);
    }

    public void ejectPassengers(String reason) {
        TextComponent component = ComponentUtil.buildColoredTextComponent(reason);
        for (Entity passenger : this.m_20197_()) {
            passenger.m_8127_();
            passenger.m_6352_((Component)component, passenger.m_142081_());
        }
    }

    public Optional<ServerPlayer> getRider() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)passenger;
            return Optional.of(serverPlayer);
        }
        return Optional.empty();
    }

    public void m_7332_(Entity entity) {
        entity.m_6034_(this.m_20185_(), this.m_20186_() + (HorseHeightUtil.scaleToMeters(this.getModelScaleAtSpawn()) + entity.m_6049_()) - 0.1, this.m_20189_());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_20883_ = this.f_20883_;
        }
    }

    public void m_7023_(Vec3 vec) {
        if (this.freeze) {
            this.currentVector = Vec3.f_82478_;
            return;
        }
        if (this.m_6084_()) {
            Entity entity;
            this.f_20924_ = 1.0f;
            if (this.m_20160_() && (entity = this.m_6688_()) instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                if (this.isJumping()) {
                    passenger.m_146922_(this.m_146908_());
                    this.f_19859_ = this.m_146908_();
                } else {
                    passenger.m_146922_(passenger.m_146908_());
                    float maximumRotation = this.determineMaximumRotation();
                    if (maximumRotation > 0.0f) {
                        float currentYRot = this.m_146908_();
                        float deltaYRot = passenger.m_146908_() - currentYRot;
                        float newYRot = currentYRot + NumberUtils.keepWithinRange(Float.valueOf(deltaYRot), Float.valueOf(-maximumRotation), Float.valueOf(maximumRotation)).floatValue();
                        this.m_146922_(newYRot);
                        passenger.m_146922_(newYRot);
                    } else {
                        this.m_146922_(passenger.m_146908_());
                    }
                }
                this.m_146926_(passenger.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float playerXInput = passenger.f_20900_ * 0.5f;
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.f_19861_) {
                    double d0 = (double)this.getMaxHorseJump() / 1.5 * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + this.m_182332_();
                    this.jumpTime = AnimUtil.JUMP.getStartOffset() / 2.0f;
                    this.jumpPower = (float)d1;
                    this.isJumpingPlayed = true;
                    this.isJumping = true;
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    float playerZInput = passenger.f_20902_;
                    if (playerZInput <= 0.0f) {
                        playerZInput *= 0.25f;
                    }
                    if (playerZInput > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.f_20887_ = this.m_6113_() * 0.1f;
                this.currentVector = new Vec3((double)playerXInput, 0.0, 1.0).m_82542_((double)this.getMaximumSideSteppingSpeed(), 0.0, 0.5);
                if (this.f_19861_) {
                    this.playerJumpPendingScale = 0.0f;
                    this.isJumping = false;
                    this.m_8012_();
                }
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                this.currentVector = new Vec3(0.0, 0.0, 0.5);
            }
            if (this.m_20069_() && this.m_204036_(FluidTags.f_13131_) <= 1.0) {
                this.currentVector = this.currentVector.m_82542_(0.0, 0.0, 2.0);
            }
            this.m_7910_(this.getSpeedPolicy().getSpeed(this));
            this.currentVector = this.currentVector.m_82559_(this.determineGroundVector());
            this.getTravelPolicy().travel(this, this.currentVector);
            super.m_7023_(this.currentVector);
        }
    }

    private Vec3 determineGroundVector() {
        float traction = switch (this.getGroundType()) {
            default -> throw new IncompatibleClassChangeError();
            case GroundType.HARD -> this.getHardGroundTraction();
            case GroundType.SOFT -> this.getSoftGroundTraction();
            case GroundType.LOOSE -> this.getLooseGroundTraction();
        };
        return new Vec3((double)traction, 0.0, (double)traction);
    }

    private GroundType getGroundType() {
        Block block = this.m_183503_().m_8055_(this.m_20097_()).m_60734_();
        return BlockGroundTypeMapper.getType(block);
    }

    private float determineMaximumRotation() {
        float speed = this.getBaseSpeed();
        speed = Math.min(speed, 0.8f);
        float speedRemaining = 1.0f - speed;
        speedRemaining = NumberUtils.keepWithinRange(Float.valueOf(speedRemaining), Float.valueOf(0.0f), Float.valueOf(1.0f)).floatValue();
        return this.getMaximumYRotation() * speedRemaining;
    }

    public EnvironmentType getCurrentEnvironment() {
        return this.f_19853_.m_45527_(this.m_20097_()) ? EnvironmentType.OUTDOOR : EnvironmentType.INDOOR;
    }

    public void m_7888_(int val) {
        this.playerJumpPendingScale = val >= 90 && this.playerJumpPendingScale == 0.0f ? 1.0f : 0.4f + 0.4f * (float)val / 90.0f;
    }

    private void eating() {
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11976_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
        }
    }

    public void onAddedToWorld() {
        this.m_6862_(false);
        this.setJumpingPlayed(false);
        super.onAddedToWorld();
        if (!this.f_19853_.m_5776_()) {
            this.getAddPolicy().onHorseAdd(this);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.f_19853_.f_46443_) {
            this.getRemovePolicy().onHorseRemove(this, reason);
        }
        super.m_142687_(reason);
    }

    private void onChangedChunk() {
        if (!this.f_19853_.f_46443_) {
            HorseEventHandler.getInstance().fireChunkChangeEvent(this);
        }
    }

    public String getCurrentAnimation() {
        return (String)this.f_19804_.m_135370_(currentAnimation);
    }

    public void setCurrentAnimation(String animation) {
        this.f_19804_.m_135381_(currentAnimation, (Object)animation);
    }

    public HorseGaitVariant getGaitVariant() {
        return HorseGaitVariant.valueOf((String)this.f_19804_.m_135370_(gaitVariant));
    }

    public void setGaitVariant(HorseGaitVariant variant) {
        this.f_19804_.m_135381_(gaitVariant, (Object)variant.name());
    }

    public HorseSubGait getGait() {
        String gaitType = (String)this.f_19804_.m_135370_(horseGait);
        try {
            return HorseGaitCache.getInstance().findByGaitType(Gait.valueOf(gaitType));
        }
        catch (Exception ex) {
            return Halt.DEFAULT;
        }
    }

    public void setGait(HorseSubGait gait) {
        this.f_19804_.m_135381_(horseGait, (Object)gait.getGaitType().name());
        HorseStat speed = this.getSpeedPolicy().getSpeed(this, gait);
        this.setBlocksPerSecondSpeed(speed.value());
        this.setCurrentGaitImpairmentFactor(speed.getImpairmentFactor());
        if (this.horseData != null) {
            this.horseData.getGait().setCurrentGait(gait);
        }
    }

    public HorseLeadDirection getLeadDirection() {
        return HorseLeadDirection.valueOf((String)this.f_19804_.m_135370_(leadDirection));
    }

    public void setLeadDirection(HorseLeadDirection lead) {
        this.f_19804_.m_135381_(leadDirection, (Object)lead.name());
    }

    @Override
    public void setBaseSpeed(float speed) {
        this.requireMovementSpeedAttribute().m_22100_((double)speed);
    }

    public void setBlocksPerSecondSpeed(float blocksPerSecondSpeed) {
        this.setBaseSpeed(blocksPerSecondSpeed * 0.05f);
    }

    public float getBaseSpeed() {
        return (float)this.requireMovementSpeedAttribute().m_22115_();
    }

    private AttributeInstance requireMovementSpeedAttribute() {
        return Objects.requireNonNull(this.m_21051_(Attributes.f_22279_));
    }

    public float getMaxHorseJump() {
        return ((Float)this.f_19804_.m_135370_(maxHorseJump)).floatValue();
    }

    public void setMaxHorseJump(float jump) {
        this.f_19804_.m_135381_(maxHorseJump, (Object)Float.valueOf(jump * 0.1f));
    }

    public HorseEntityType getHorseEntityType() {
        String type = (String)this.f_19804_.m_135370_(horseType);
        return HorseEntityType.valueOf(type);
    }

    public void setHorseEntityType(HorseEntityType type) {
        this.f_19804_.m_135381_(horseType, (Object)type.name());
    }

    @Override
    public int getInternalId() {
        return (Integer)this.f_19804_.m_135370_(internalId);
    }

    @Override
    public boolean isNpc() {
        return this.getHorseEntityType() == HorseEntityType.NPC;
    }

    @Override
    public void setInternalId(int id) {
        this.f_19804_.m_135381_(internalId, (Object)id);
    }

    @Override
    public CompoundTag getVisibilitySettingsTag() {
        return (CompoundTag)this.f_19804_.m_135370_(visibilitySettings);
    }

    @Override
    public void setVisibilitySettingsTag(CompoundTag tag) {
        this.f_19804_.m_135381_(visibilitySettings, (Object)tag);
    }

    public boolean m_20145_() {
        if (this.f_19853_.f_46443_) {
            return !this.getVisibilityPolicy().shouldHorseShow(this);
        }
        return super.m_20145_();
    }

    public boolean isInDayTime() {
        long time = this.m_183503_().m_46468_() % 24000L;
        return time >= 0L && time < 12000L;
    }

    public String getColorName() {
        return (String)this.f_19804_.m_135370_(colorName);
    }

    public void setColorName(String name) {
        this.f_19804_.m_135381_(colorName, (Object)name);
    }

    public String getPatternNames() {
        return (String)this.f_19804_.m_135370_(patternNames);
    }

    public void setPatternNames(String name) {
        this.f_19804_.m_135381_(patternNames, (Object)name);
    }

    public String getGrayName() {
        return (String)this.f_19804_.m_135370_(grayName);
    }

    public void setGrayName(String name) {
        this.f_19804_.m_135381_(grayName, (Object)name);
    }

    public String getTextureBase64() {
        return (String)this.f_19804_.m_135370_(textureBase64);
    }

    public void setTextureBase64(String base64Texture) {
        this.f_19804_.m_135381_(textureBase64, (Object)base64Texture);
    }

    public HorseGender getGender() {
        String genderName = (String)this.f_19804_.m_135370_(gender);
        return HorseGender.valueOf(genderName);
    }

    public void setGender(HorseGender genderValue) {
        this.f_19804_.m_135381_(gender, (Object)genderValue.name());
    }

    public float m_6118_() {
        return this.jumpPower;
    }

    public float getJumpTime() {
        return this.jumpTime;
    }

    public void addJumpTime(float time) {
        this.jumpTime += time;
    }

    public void setJumpTime(float time) {
        this.jumpTime = time;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public boolean isJumpingPlayed() {
        return this.isJumpingPlayed;
    }

    public void setJumpingPlayed(boolean played) {
        this.isJumpingPlayed = played;
    }

    public boolean isEating() {
        return this.isEating;
    }

    public void setEating(boolean isEating) {
        this.isEating = isEating;
    }

    public boolean m_142391_() {
        return false;
    }

    public void negativeRideEnd(String reason) {
        this.badRideEnd = true;
        this.ejectPassengers(reason);
    }

    public boolean didLastRideEndBadly() {
        return this.badRideEnd;
    }

    public void clearBadRideEnd() {
        this.badRideEnd = false;
    }

    public EntityHorse getTargetForBreeding() {
        return this.targetForBreeding;
    }

    public void setTargetForBreeding(EntityHorse targetForBreeding) {
        this.targetForBreeding = targetForBreeding;
    }

    public HorseBonnetModel getBonnetModel() {
        String bonnetName = (String)this.f_19804_.m_135370_(bonnetModel);
        if (bonnetName.isEmpty()) {
            return null;
        }
        return HorseBonnetModel.valueOf(bonnetName);
    }

    public void setBonnetModel(HorseBonnetModel model) {
        String name = model != null ? model.name() : "";
        this.f_19804_.m_135381_(bonnetModel, (Object)name);
    }

    public HorseBootsModel getBootsModel() {
        String bootsName = (String)this.f_19804_.m_135370_(bootsModel);
        if (bootsName.isEmpty()) {
            return null;
        }
        return HorseBootsModel.valueOf(bootsName);
    }

    public void setBootsModel(HorseBootsModel model) {
        String name = model != null ? model.name() : "";
        this.f_19804_.m_135381_(bootsModel, (Object)name);
    }

    public HorseBridleModel getBridleModel() {
        String bridleName = (String)this.f_19804_.m_135370_(bridleModel);
        if (bridleName.isEmpty()) {
            return null;
        }
        return HorseBridleModel.valueOf(bridleName);
    }

    public void setBridleModel(HorseBridleModel model) {
        String name = model != null ? model.name() : "";
        this.f_19804_.m_135381_(bridleModel, (Object)name);
    }

    public HorseCinchModel getCinchModel() {
        String cinchName = (String)this.f_19804_.m_135370_(cinchModel);
        if (cinchName.isEmpty()) {
            return null;
        }
        return HorseCinchModel.valueOf(cinchName);
    }

    public void setCinchModel(HorseCinchModel model) {
        String name = model != null ? model.name() : "";
        this.f_19804_.m_135381_(cinchModel, (Object)name);
    }

    public HorseGirthModel getGirthModel() {
        String girthName = (String)this.f_19804_.m_135370_(girthModel);
        if (girthName.isEmpty()) {
            return null;
        }
        return HorseGirthModel.valueOf(girthName);
    }

    public void setGirthModel(HorseGirthModel model) {
        String name = model != null ? model.name() : "";
        this.f_19804_.m_135381_(girthModel, (Object)name);
    }

    public HorseHalterModel getHalterModel() {
        String halterName = (String)this.f_19804_.m_135370_(halterModel);
        if (halterName.isEmpty()) {
            return null;
        }
        return HorseHalterModel.valueOf(halterName);
    }

    public void setHalterModel(HorseHalterModel model) {
        String name = model != null ? model.name() : "";
        this.f_19804_.m_135381_(halterModel, (Object)name);
    }

    public HorsePadModel getPadModel() {
        String padName = (String)this.f_19804_.m_135370_(padModel);
        if (padName.isEmpty()) {
            return null;
        }
        return HorsePadModel.valueOf(padName);
    }

    public void setPadModel(HorsePadModel model) {
        String name = model != null ? model.name() : "";
        this.f_19804_.m_135381_(padModel, (Object)name);
    }

    public HorseReinModel getReinModel() {
        String reinName = (String)this.f_19804_.m_135370_(reinModel);
        if (reinName.isEmpty()) {
            return null;
        }
        return HorseReinModel.valueOf(reinName);
    }

    public void setReinModel(HorseReinModel model) {
        String name = model != null ? model.name() : "";
        this.f_19804_.m_135381_(reinModel, (Object)name);
    }

    public HorseSaddleModel getSaddleModel() {
        String saddleName = (String)this.f_19804_.m_135370_(saddleModel);
        if (saddleName.isEmpty()) {
            return null;
        }
        return HorseSaddleModel.valueOf(saddleName);
    }

    public void setSaddleModel(HorseSaddleModel model) {
        String name = model != null ? model.name() : "";
        this.f_19804_.m_135381_(saddleModel, (Object)name);
    }

    public HorseWrapsModel getWrapsModel() {
        String wrapsName = (String)this.f_19804_.m_135370_(wrapsModel);
        if (wrapsName.isEmpty()) {
            return null;
        }
        return HorseWrapsModel.valueOf(wrapsName);
    }

    public void setWrapsModel(HorseWrapsModel model) {
        String name = model != null ? model.name() : "";
        this.f_19804_.m_135381_(wrapsModel, (Object)name);
    }

    public float getRefTime() {
        return this.refTime;
    }

    public void setRefTime(float refTime) {
        this.refTime = refTime;
    }

    public synchronized HorseSpeedDecreaseHandler getSpeedDecreaseHandler() {
        if (this.speedDecreaseHandler == null) {
            this.speedDecreaseHandler = new HorseSpeedDecreaseHandler(this.horseData);
        }
        return this.speedDecreaseHandler;
    }

    public boolean isConsumingFromProvisionContainer() {
        return (Boolean)this.f_19804_.m_135370_(consumingFromProvisionContainer);
    }

    public void setConsumingFromProvisionContainer(boolean consuming) {
        this.f_19804_.m_135381_(consumingFromProvisionContainer, (Object)consuming);
    }

    public int getAgeMonthsAtSpawn() {
        return (Integer)this.f_19804_.m_135370_(ageMonthsAtSpawn);
    }

    public void setAgeMonthsAtSpawn(int value) {
        this.f_19804_.m_135381_(ageMonthsAtSpawn, (Object)value);
    }

    public float getModelScaleAtSpawn() {
        return ((Float)this.f_19804_.m_135370_(modelScaleAtSpawn)).floatValue();
    }

    public void setModelScaleAtSpawn(float value) {
        this.f_19804_.m_135381_(modelScaleAtSpawn, (Object)Float.valueOf(value));
    }

    public float getMaximumYRotation() {
        return ((Float)this.f_19804_.m_135370_(maximumYRotation)).floatValue();
    }

    public void setMaximumYRotation(float value) {
        this.f_19804_.m_135381_(maximumYRotation, (Object)Float.valueOf(value));
    }

    public float getMaximumSideSteppingSpeed() {
        return ((Float)this.f_19804_.m_135370_(maximumSideSteppingSpeed)).floatValue();
    }

    public void setMaximumSideSteppingSpeed(float value) {
        this.f_19804_.m_135381_(maximumSideSteppingSpeed, (Object)Float.valueOf(value));
    }

    public float getCurrentGaitImpairmentFactor() {
        return ((Float)this.f_19804_.m_135370_(currentGaitImpairmentFactor)).floatValue();
    }

    public void setCurrentGaitImpairmentFactor(float value) {
        this.f_19804_.m_135381_(currentGaitImpairmentFactor, (Object)Float.valueOf(value));
    }

    public float getHardGroundTraction() {
        return ((Float)this.f_19804_.m_135370_(hardTraction)).floatValue();
    }

    public void setHardGroundTraction(float value) {
        this.f_19804_.m_135381_(hardTraction, (Object)Float.valueOf(value));
    }

    public float getSoftGroundTraction() {
        return ((Float)this.f_19804_.m_135370_(softTraction)).floatValue();
    }

    public void setSoftGroundTraction(float value) {
        this.f_19804_.m_135381_(softTraction, (Object)Float.valueOf(value));
    }

    public float getLooseGroundTraction() {
        return ((Float)this.f_19804_.m_135370_(looseTraction)).floatValue();
    }

    public void setLooseGroundTraction(float value) {
        this.f_19804_.m_135381_(looseTraction, (Object)Float.valueOf(value));
    }

    public int getOwnerId() {
        return (Integer)this.f_19804_.m_135370_(ownerId);
    }

    public void setOwnerId(int value) {
        this.f_19804_.m_135381_(ownerId, (Object)value);
    }

    public boolean isFreeze() {
        return this.freeze;
    }

    public void setFreeze(boolean freeze) {
        this.freeze = freeze;
    }

    public long getLastSpeedIncreaseInput() {
        return this.lastSpeedIncreaseInput;
    }

    public void setLastSpeedIncreaseInput(long lastSpeedIncreaseInput) {
        this.lastSpeedIncreaseInput = lastSpeedIncreaseInput;
    }

    public LungeAroundPlayerGoal getLungeGoal() {
        return GoalUtil.findGoal((Mob)this, LungeAroundPlayerGoal.class);
    }

    public HorseWalkStraightGoal getWalkStraightGoal() {
        return GoalUtil.findGoal((Mob)this, HorseWalkStraightGoal.class);
    }

    public HorsePanicGoal getPanicGoal() {
        return GoalUtil.findGoal((Mob)this, HorsePanicGoal.class);
    }

    public HorseFleeGoal getFleeGoal() {
        return GoalUtil.findGoal((Mob)this, HorseFleeGoal.class);
    }

    public HorseFollowPlayerGoal getFollowPlayerGoal() {
        return GoalUtil.findGoal((Mob)this, HorseFollowPlayerGoal.class);
    }

    public HorseRunInGroupGoal getRunInGroupGoal() {
        return GoalUtil.findGoal((Mob)this, HorseRunInGroupGoal.class);
    }

    public HorseRandomWanderGoal getRandomWanderGoal() {
        return GoalUtil.findGoal((Mob)this, HorseRandomWanderGoal.class);
    }

    public HorseWanderToOtherHorseGoal getWanderToOtherHorseGoal() {
        return GoalUtil.findGoal((Mob)this, HorseWanderToOtherHorseGoal.class);
    }

    public MareAcceptMateGoal getAcceptMateGoal() {
        return GoalUtil.findGoal((Mob)this, MareAcceptMateGoal.class);
    }

    public HorsePlayActionGoal getPlayActionGoal() {
        return GoalUtil.findGoal((Mob)this, HorsePlayActionGoal.class);
    }

    public HorseSlowDownStraightGoal getSlowDownStraightGoal() {
        return GoalUtil.findGoal((Mob)this, HorseSlowDownStraightGoal.class);
    }

    public HorseRespondToCallGoal getResponseToCallGoal() {
        return GoalUtil.findGoal((Mob)this, HorseRespondToCallGoal.class);
    }

    public void setPanic(Duration duration) {
        this.getPanicGoal().setPanicDuration(duration);
    }

    public void fleeFrom(Vec3 position) {
        this.getFleeGoal().setFleePosition(position);
    }

    public void stopFollowing() {
        this.getFollowPlayerGoal().stopFollow();
    }

    public HorseVisibilityPolicy getVisibilityPolicy() {
        if (this.visibilityPolicy == null) {
            this.visibilityPolicy = this.getHorseEntityType().getVisibilityPolicy();
        }
        return this.visibilityPolicy;
    }

    public HorseInteractPolicy getInteractPolicy() {
        if (this.interactPolicy == null) {
            this.interactPolicy = this.getHorseEntityType().getInteractPolicy();
        }
        return this.interactPolicy;
    }

    public HorseAddPolicy getAddPolicy() {
        if (this.addPolicy == null) {
            this.addPolicy = this.getHorseEntityType().getAddPolicy();
        }
        return this.addPolicy;
    }

    public HorseRemovePolicy getRemovePolicy() {
        if (this.removePolicy == null) {
            this.removePolicy = this.getHorseEntityType().getRemovePolicy();
        }
        return this.removePolicy;
    }

    public HorseServerTickPolicy getServerTickPolicy() {
        if (this.serverTickPolicy == null) {
            this.serverTickPolicy = this.getHorseEntityType().getServerTickPolicy();
        }
        return this.serverTickPolicy;
    }

    public HorseSpeedPolicy getSpeedPolicy() {
        if (this.speedPolicy == null) {
            this.speedPolicy = this.getHorseEntityType().getSpeedPolicy();
        }
        return this.speedPolicy;
    }

    public HorseTravelPolicy getTravelPolicy() {
        if (this.travelPolicy == null) {
            this.travelPolicy = this.getHorseEntityType().getTravelPolicy();
        }
        return this.travelPolicy;
    }

    public HorseMountPolicy getMountPolicy() {
        if (this.mountPolicy == null) {
            this.mountPolicy = this.getHorseEntityType().getMountPolicy();
        }
        return this.mountPolicy;
    }

    public HorseLeashPolicy getLeashPolicy() {
        if (this.leashPolicy == null) {
            this.leashPolicy = this.getHorseEntityType().getLeashPolicy();
        }
        return this.leashPolicy;
    }

    public HorseSpeedControlPolicy getSpeedControlPolicy() {
        if (this.speedControlPolicy == null) {
            this.speedControlPolicy = this.getHorseEntityType().getSpeedControlPolicy();
        }
        return this.speedControlPolicy;
    }

    public EQHorse getHorseData() {
        return this.horseData;
    }

    public void setHorseData(EQHorse horseData) {
        this.horseData = horseData;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }
}

