/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.horse;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.horse.list.HorseListSortOrder;
import com.equestricraft.core.horse.speed.HorseLeadDirection;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.hud.HorseRidingHudElement;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundGallopCancelPacket;
import com.equestricraft.mod.packet.ServerBoundHorseChangeGaitPacket;
import com.equestricraft.mod.packet.ServerBoundHorseChangeGaitSpeedPacket;
import com.equestricraft.mod.packet.ServerBoundHorseHaltPacket;
import com.equestricraft.mod.packet.ServerBoundHorseListRefreshPacket;
import com.equestricraft.mod.packet.ServerBoundHorseMountNearestPacket;
import com.equestricraft.mod.packet.ServerBoundHorseSideStepPacket;
import com.equestricraft.mod.packet.ServerBoundTpSelectedHorsePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HorseInputListener {
    @SubscribeEvent
    public static void keyboardInputEvent(InputEvent.KeyInputEvent event) {
        Entity entity;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        Screen screen = minecraft.f_91080_;
        if (player != null && screen == null && (entity = player.m_20202_()) instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)entity;
            char key = (char)event.getKey();
            if (event.getAction() == 1) {
                switch (key) {
                    case 'W': {
                        HorseInputListener.increaseGait(horse);
                        break;
                    }
                    case 'S': {
                        HorseInputListener.decreaseGait(horse);
                        break;
                    }
                    case 'C': {
                        HorseInputListener.increaseGaitSpeed(horse);
                        break;
                    }
                    case 'V': {
                        HorseInputListener.decreaseGaitSpeed(horse);
                        break;
                    }
                    case 'R': {
                        HorseInputListener.flipLeadDirection(horse);
                        break;
                    }
                    case 'A': 
                    case 'D': {
                        HorseInputListener.sendSideStep(horse);
                    }
                }
            } else if (event.getAction() == 0) {
                if (key == 'W') {
                    HorseInputListener.cancelGallop(horse);
                }
            } else if (event.getAction() == 2 && key == 'S') {
                HorseInputListener.halt(horse);
            }
        }
    }

    @SubscribeEvent
    public static void mountKeyEvent(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        Screen screen = minecraft.f_91080_;
        if (player != null && screen == null && player.m_20202_() == null) {
            char key = (char)event.getKey();
            if (event.getAction() == 1 && key == 'G') {
                Network.sendToServer(new ServerBoundHorseMountNearestPacket());
            }
        }
    }

    @SubscribeEvent
    public static void tpHorseKeyEvent(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        Screen screen = minecraft.f_91080_;
        if (player != null && screen == null && player.m_20202_() == null) {
            char key = (char)event.getKey();
            if (event.getAction() == 1 && key == 'Y') {
                Network.sendToServer(new ServerBoundTpSelectedHorsePacket());
            }
        }
    }

    @SubscribeEvent
    public static void openHorseListKeyEvent(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        Screen screen = minecraft.f_91080_;
        if (player != null && screen == null && player.m_20202_() == null) {
            char key = (char)event.getKey();
            if (event.getAction() == 1 && key == 'H') {
                Network.sendToServer(new ServerBoundHorseListRefreshPacket(1, HorseListSortOrder.NATURAL, SortDirection.ASCENDING, ""));
            }
        }
    }

    private static void increaseGait(EntityHorse horse) {
        Network.sendToServer(new ServerBoundHorseChangeGaitPacket(horse.m_142081_(), true));
    }

    private static void decreaseGait(EntityHorse horse) {
        Network.sendToServer(new ServerBoundHorseChangeGaitPacket(horse.m_142081_(), false));
    }

    private static void increaseGaitSpeed(EntityHorse horse) {
        Network.sendToServer(new ServerBoundHorseChangeGaitSpeedPacket(horse.m_142081_(), true));
    }

    private static void decreaseGaitSpeed(EntityHorse horse) {
        Network.sendToServer(new ServerBoundHorseChangeGaitSpeedPacket(horse.m_142081_(), false));
    }

    private static void flipLeadDirection(EntityHorse horse) {
        HorseLeadDirection oppositeLeadDirection = horse.getLeadDirection().getOpposite();
        HorseRidingHudElement.setLead(oppositeLeadDirection);
        horse.setLeadDirection(oppositeLeadDirection);
    }

    private static void cancelGallop(EntityHorse horse) {
        Network.sendToServer(new ServerBoundGallopCancelPacket(horse.m_142081_()));
    }

    private static void halt(EntityHorse horse) {
        Network.sendToServer(new ServerBoundHorseHaltPacket(horse.m_142081_()));
    }

    private static void sendSideStep(EntityHorse horse) {
        Network.sendToServer(new ServerBoundHorseSideStepPacket(horse.m_142081_()));
    }

    @SubscribeEvent
    public static void onInputUpdate(MovementInputUpdateEvent event) {
        if (event.getPlayer().m_20202_() instanceof EntityHorse) {
            event.getInput().f_108567_ = 1.0f;
        }
    }

    private HorseInputListener() {
    }
}

