/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.horse;

import com.equestricraft.common.Argb;
import com.equestricraft.logging.Log;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class HorseTextureCombiner {
    private static final ResourceLocation FALLBACK_HORSE_TEXTURE = new ResourceLocation("equestricraft", "textures/entities/horse/default.png");
    private static final Log log = Log.getLogger(HorseTextureCombiner.class.getName());

    public static NativeImage createNativeImage(ResourceLocation colorResource, List<ResourceLocation> patternResources, ResourceLocation grayResource) {
        try {
            BufferedImage colorTexture = HorseTextureCombiner.getImage(colorResource);
            ArrayList<BufferedImage> patternTextures = new ArrayList<BufferedImage>(patternResources.size());
            for (ResourceLocation patternResource : patternResources) {
                BufferedImage image = HorseTextureCombiner.getImage(patternResource);
                if (colorTexture.getWidth() != image.getWidth() && colorTexture.getHeight() != image.getHeight()) {
                    throw new IllegalArgumentException("Both images must be of the same dimensions");
                }
                patternTextures.add(image);
            }
            BufferedImage grayTexture = grayResource != null ? HorseTextureCombiner.getImage(grayResource) : null;
            int width = colorTexture.getWidth();
            int height = colorTexture.getHeight();
            NativeImage nativeImage = new NativeImage(width, height, true);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    Argb colorArgb = Argb.fromIntValue(colorTexture.getRGB(x, y));
                    Argb patternArgb = null;
                    for (BufferedImage image : patternTextures) {
                        Argb currentArgb = Argb.fromIntValue(image.getRGB(x, y));
                        if (patternArgb == null) {
                            patternArgb = currentArgb;
                            continue;
                        }
                        patternArgb = HorseTextureCombiner.softBlend(patternArgb, currentArgb);
                    }
                    Argb grayArgb = grayTexture != null ? Argb.fromIntValue(grayTexture.getRGB(x, y)) : null;
                    Argb colorToUse = patternArgb == null ? colorArgb : HorseTextureCombiner.softBlend(colorArgb, patternArgb);
                    colorToUse = grayArgb != null ? Argb.blend(colorToUse, grayArgb) : colorToUse;
                    nativeImage.m_84988_(x, y, colorToUse.invert().getIntValue());
                }
            }
            return nativeImage;
        }
        catch (IOException ex) {
            log.error("Error getting texture for horse, so using the fallback texture for now", ex);
            return HorseTextureCombiner.getFallbackImage();
        }
    }

    private static NativeImage getFallbackImage() {
        try {
            BufferedImage image = HorseTextureCombiner.getImage(FALLBACK_HORSE_TEXTURE);
            NativeImage nativeImage = new NativeImage(image.getWidth(), image.getHeight(), true);
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    Argb colorArgb = Argb.fromIntValue(image.getRGB(x, y));
                    nativeImage.m_84988_(x, y, colorArgb.invert().getIntValue());
                }
            }
            return nativeImage;
        }
        catch (IOException ex2) {
            throw new IllegalArgumentException("Error getting fallback texture");
        }
    }

    private static Argb softBlend(Argb color1, Argb color2) {
        int resultA = color1.alpha();
        int resultR = color1.red();
        int resultG = color1.green();
        int resultB = color1.blue();
        if (color2.alpha() > 0) {
            float transparencyPercentage = (float)color2.alpha() / 255.0f;
            int deltaR = resultR - color2.red();
            int deltaG = resultG - color2.green();
            int deltaB = resultB - color2.blue();
            int rToRemove = (int)((float)deltaR * transparencyPercentage);
            int gToRemove = (int)((float)deltaG * transparencyPercentage);
            int bToRemove = (int)((float)deltaB * transparencyPercentage);
            resultR -= rToRemove;
            resultG -= gToRemove;
            resultB -= bToRemove;
        }
        return new Argb(resultA, resultR, resultG, resultB);
    }

    private static BufferedImage getImage(ResourceLocation resourceLocation) throws IOException {
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        Resource resource = manager.m_142591_(resourceLocation);
        try (InputStream inputStream2 = resource.m_6679_();){
            BufferedImage bufferedImage = ImageIO.read(inputStream2);
            return bufferedImage;
        }
    }

    private HorseTextureCombiner() {
    }
}

