/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.hud;

import com.equestricraft.common.Argb;
import com.equestricraft.common.LimitedList;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.hud.HudElement;

public class DebugHudElement
extends HudElement {
    private static final LimitedList<Entry> items = new LimitedList(10);

    public static void addText(String text) {
        Entry entry = new Entry(text);
        items.add(entry);
    }

    @Override
    protected int getXPosition() {
        return this.getWindowWidth() - 150;
    }

    @Override
    protected int getYPosition() {
        return 10;
    }

    @Override
    protected void render() {
        int y = 0;
        for (Entry entry : items) {
            if (entry.getAgeSeconds() >= 10) continue;
            this.renderString(0, y, entry.getText(), Argb.ARGB_WHITE);
            y += GuiUtil.getStandardLineHeight();
        }
    }

    @Override
    protected void reset() {
        items.clear();
    }

    private static class Entry {
        private final String text;
        private final long time = System.currentTimeMillis();

        public Entry(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public int getAgeSeconds() {
            return DateUtils.secondsSince(this.time);
        }
    }
}

