/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.hud;

import com.equestricraft.common.Argb;
import com.equestricraft.core.horse.speed.HorseLeadDirection;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.hud.HudElement;
import com.equestricraft.mod.util.ComponentUtil;
import java.time.LocalDateTime;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class HorseRidingHudElement
extends HudElement {
    private static TextComponent speedDisplayComponent = null;
    private static boolean atSpeedWithLead = false;
    private static boolean droppingSoon = false;
    private static boolean showStamina = false;
    private static int staminaPercentage = 0;
    private static boolean staminaIsLow = false;
    private static int labelWidth = 0;
    private static TextComponent leadDisplayComponent = null;

    public static void setHorseRidingInformation(String name, boolean leadSelectionAvailable) {
        if (name != null) {
            speedDisplayComponent = ComponentUtil.buildColoredTextComponent(name);
            atSpeedWithLead = leadSelectionAvailable;
            labelWidth = GuiUtil.getStandardTextWidth((Component)speedDisplayComponent);
        } else {
            speedDisplayComponent = null;
            atSpeedWithLead = false;
            labelWidth = 0;
        }
        droppingSoon = false;
    }

    public static void setDroppingSoon(boolean flag) {
        droppingSoon = flag;
    }

    public static void setStaminaPercentage(int value, boolean isLow) {
        staminaPercentage = value;
        staminaIsLow = isLow;
        showStamina = true;
    }

    public static void hideStamina() {
        showStamina = false;
    }

    public static void setLead(HorseLeadDirection lead) {
        leadDisplayComponent = ComponentUtil.buildColoredTextComponent(lead.getTranslatedName());
    }

    public static void clearLead() {
        leadDisplayComponent = null;
    }

    @Override
    protected int getXPosition() {
        return this.getWindowWidth() - 105;
    }

    @Override
    protected int getYPosition() {
        return 100;
    }

    @Override
    protected void render() {
        this.width = labelWidth + 5;
        if (speedDisplayComponent != null) {
            this.renderString(0, 0, speedDisplayComponent, droppingSoon ? this.flashing(Argb.ARGB_AQUA) : Argb.ARGB_AQUA);
        }
        this.renderStaminaBar();
        this.renderLeadLabel();
    }

    @Override
    protected void reset() {
        speedDisplayComponent = null;
        atSpeedWithLead = false;
        droppingSoon = false;
        showStamina = false;
        staminaPercentage = 0;
        staminaIsLow = false;
        labelWidth = 0;
        leadDisplayComponent = null;
    }

    private void renderStaminaBar() {
        if (showStamina && FeatureFlag.STAMINA.isEnabled()) {
            Argb staminaBarColor = staminaIsLow ? this.flashing(Argb.ARGB_GREEN) : Argb.ARGB_GREEN;
            int height = GuiUtil.getStandardLineHeight() + 5;
            this.renderFilledSquare(0, height, staminaPercentage, 3, staminaBarColor);
            this.renderFilledSquare(staminaPercentage, height, 100 - staminaPercentage, 3, Argb.ARGB_MC_GRAY);
        }
    }

    private Argb flashing(Argb defaultColor) {
        int millis = LocalDateTime.now().getNano() / 1000000;
        boolean red = millis % 500 < 250;
        return red ? Argb.ARGB_RED : defaultColor;
    }

    private void renderLeadLabel() {
        if (leadDisplayComponent != null) {
            this.renderString(0, 23, leadDisplayComponent, atSpeedWithLead ? Argb.ARGB_WHITE : Argb.ARGB_MC_GRAY);
        }
    }
}

