/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.hud;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.hud.HudListener;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.image.BufferedImage;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class HudElement {
    private PoseStack currentPoseStack;
    private Window currentWindow;
    int width = 0;
    int height = 0;

    protected final void renderString(int x, int y, String string, Argb color) {
        GuiUtil.drawString(this.currentPoseStack, string, this.dx(x), this.dy(y), color);
    }

    protected final void renderString(int x, int y, String string, Argb color, float scale) {
        this.currentPoseStack.m_85836_();
        this.currentPoseStack.m_85841_(scale, scale, scale);
        this.renderString(x, y, string, color);
        this.currentPoseStack.m_85849_();
    }

    protected final void renderString(int x, int y, TextComponent component, Argb color) {
        GuiUtil.drawString(this.currentPoseStack, (Component)component, this.dx(x), this.dy(y), color);
    }

    protected final void renderCenteredString(int x, int y, String string, Argb color) {
        GuiUtil.drawCenteredString(this.currentPoseStack, string, this.dx(x), this.dy(y), color);
    }

    protected final void renderCenteredString(int x, int y, TextComponent component, Argb color) {
        GuiUtil.drawCenteredString(this.currentPoseStack, (Component)component, this.dx(x), this.dy(y), color);
    }

    protected final void renderImage(int x, int y, int width, int height, ResourceLocation resourceLocation) {
        GuiUtil.drawImage(this.currentPoseStack, resourceLocation, this.dx(x), this.dy(y), width, height);
    }

    protected final void renderImage(int x, int y, int width, int height, String resourcePath) {
        GuiUtil.drawImage(this.currentPoseStack, resourcePath, this.dx(x), this.dy(y), width, height);
    }

    protected final void renderImage(int x, int y, int width, int height, BufferedImage image) {
        GuiUtil.drawImage(this.currentPoseStack, image, this.dx(x), this.dy(y), width, height);
    }

    protected final void renderFilledSquare(int x, int y, int width, int height, Argb color) {
        GuiUtil.drawFilledSquare(this.currentPoseStack, this.dx(x), this.dy(y), width, height, color);
    }

    protected final void renderSquare(int x, int y, int width, int height, int borderWidth, Argb color) {
        GuiUtil.drawSquare(this.currentPoseStack, this.dx(x), this.dy(y), width, height, borderWidth, color);
    }

    private int dx(int x) {
        return this.getXPosition() + x;
    }

    private int dy(int y) {
        return this.getYPosition() + y;
    }

    protected final int getWindowWidth() {
        return this.currentWindow.m_85445_();
    }

    protected final int getWindowHeight() {
        return this.currentWindow.m_85446_();
    }

    protected abstract int getXPosition();

    protected abstract int getYPosition();

    protected int getCenterX() {
        return this.width / 2;
    }

    protected int getCenterY() {
        return this.height / 2;
    }

    protected final void renderHudElement(PoseStack poseStack, Window window) {
        if (!HudListener.enabled) {
            return;
        }
        this.currentPoseStack = poseStack;
        this.currentWindow = window;
        this.setup(window);
        this.render();
    }

    protected void setup(Window window) {
    }

    protected abstract void render();

    protected abstract void reset();
}

