/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.hud;

import com.equestricraft.mod.client.hud.BuildInformationHudElement;
import com.equestricraft.mod.client.hud.DebugHudElement;
import com.equestricraft.mod.client.hud.HorseRidingHudElement;
import com.equestricraft.mod.client.hud.HudElement;
import com.equestricraft.mod.client.hud.LocationHudElement;
import com.equestricraft.mod.client.hud.PlayerNotificationHudElement;
import com.equestricraft.mod.client.hud.ProgressBarHudElement;
import com.equestricraft.mod.client.hud.QuestCompassHudElement;
import com.equestricraft.mod.client.hud.QuestHudElement;
import com.equestricraft.mod.client.hud.SelectedHorseHudElement;
import com.equestricraft.mod.client.hud.WeatherHudElement;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HudListener {
    private static List<HudElement> hudElements = null;
    protected static boolean enabled = false;

    public static void enableHud() {
        enabled = true;
    }

    @SubscribeEvent
    public static void onOverlayRender(RenderGameOverlayEvent event) {
        if (hudElements == null) {
            hudElements = HudListener.createHudList();
        }
        for (HudElement hudElement : hudElements) {
            hudElement.renderHudElement(event.getMatrixStack(), event.getWindow());
        }
    }

    private static List<HudElement> createHudList() {
        return List.of(new BuildInformationHudElement(), new HorseRidingHudElement(), new LocationHudElement(), new ProgressBarHudElement(), new QuestHudElement(), new SelectedHorseHudElement(), new WeatherHudElement(), new PlayerNotificationHudElement(), new DebugHudElement(), new QuestCompassHudElement());
    }

    @SubscribeEvent
    public static void disableHudOnDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        enabled = false;
        if (hudElements != null) {
            for (HudElement element : hudElements) {
                element.reset();
            }
        }
    }

    private HudListener() {
    }
}

