/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.hud;

import com.equestricraft.common.Argb;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.mod.client.hud.HudElement;
import com.equestricraft.mod.progressbar.ProgressBarInformation;

public class ProgressBarHudElement
extends HudElement {
    private static ProgressBarInformation progressBarInformation = null;
    private static Integer lastPercentageThroughRank = null;
    private static long lastUpdateTime = 0L;
    private static final long ANIMATION_DURATION = 1000L;
    private static final long XP_SHOW_DURATION = 2000L;

    public static void setProgressBarInformation(ProgressBarInformation progressBarInformation) {
        if (ProgressBarHudElement.progressBarInformation != null) {
            lastPercentageThroughRank = ProgressBarHudElement.progressBarInformation.percentageThroughCurrentRank();
        }
        ProgressBarHudElement.progressBarInformation = progressBarInformation;
        lastUpdateTime = System.currentTimeMillis();
    }

    ProgressBarHudElement() {
        this.width = 150;
        this.height = 2;
    }

    @Override
    protected int getXPosition() {
        int windowCenter = this.getWindowWidth() / 2;
        return windowCenter - this.width / 2;
    }

    @Override
    protected int getYPosition() {
        return 11;
    }

    @Override
    protected void render() {
        ProgressBarInformation current = progressBarInformation;
        if (current != null) {
            int currentXpAnimationWidth = this.calculateCurrentFilledWidth(current);
            this.renderFilledSquare(0, 0, currentXpAnimationWidth, this.height, current.rankColor());
            int remainingXpWidth = this.width - currentXpAnimationWidth;
            this.renderFilledSquare(currentXpAnimationWidth, 0, remainingXpWidth, this.height, Argb.ARGB_MC_GRAY);
            if (current.xpChangeAmount() > 0 && DateUtils.millisSince(lastUpdateTime) < 2000L) {
                this.renderString(currentXpAnimationWidth, 3, "+" + current.xpChangeAmount() + "xp", Argb.ARGB_WHITE);
            }
        }
    }

    @Override
    protected void reset() {
        progressBarInformation = null;
        lastPercentageThroughRank = null;
        lastUpdateTime = 0L;
    }

    private int calculateCurrentFilledWidth(ProgressBarInformation current) {
        int targetXpWidth;
        int n = targetXpWidth = current.percentageThroughCurrentRank() != null ? PercentageUtils.of(this.width, (int)current.percentageThroughCurrentRank()) : this.width;
        if (lastPercentageThroughRank != null) {
            int percentage = this.getFilledAnimationProgress();
            if (percentage >= 100) {
                return targetXpWidth;
            }
            int lastWidth = PercentageUtils.of(this.width, (int)lastPercentageThroughRank);
            int difference = targetXpWidth - lastWidth;
            int widthToAdd = PercentageUtils.of(difference, percentage);
            return lastWidth + widthToAdd;
        }
        return targetXpWidth;
    }

    private int getFilledAnimationProgress() {
        long millisSinceUpdate = DateUtils.millisSince(lastUpdateTime);
        if (millisSinceUpdate > 1000L) {
            return 100;
        }
        return (int)((double)millisSinceUpdate / 1000.0 * 100.0);
    }
}

