/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.hud;

import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.quest.QuestCompassEntry;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.hud.HudElement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class QuestCompassHudElement
extends HudElement {
    private static final List<QuestCompassEntry> coordinates = new ArrayList<QuestCompassEntry>();
    private static final ResourceLocation COMPASS_POINT_MARKER = Resources.getTextures().getGui().get("compass_point_marker.png");
    private static final ResourceLocation BACKGROUND = Resources.getTextures().getGui().get("compass.png");

    public static void addCoordinates(QuestCompassEntry coordinate) {
        coordinates.add(coordinate);
    }

    public static void removeCoordinates(UUID uuid) {
        coordinates.removeIf(c -> c.uuid().equals(uuid));
    }

    public static void clear() {
        coordinates.clear();
    }

    @Override
    protected int getXPosition() {
        return this.getWindowWidth() - 50;
    }

    @Override
    protected int getYPosition() {
        return 0;
    }

    @Override
    protected void render() {
        if (coordinates.isEmpty()) {
            return;
        }
        this.renderImage(0, 0, 50, 50, BACKGROUND);
        ArrayList<QuestCompassEntry> coords = new ArrayList<QuestCompassEntry>(coordinates);
        if (coords.isEmpty()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        int markerW = 5;
        int markerH = 5;
        float centerX = 25.0f;
        float centerY = 25.0f;
        float padding = 3.0f;
        float radius = 25.0f - (float)Math.max(5, 5) * 0.5f - 3.0f;
        for (QuestCompassEntry coordinate : coords) {
            float diff = this.getAngleDifference((Player)player, coordinate.coordinates());
            if (coordinate.invert()) {
                diff = diff >= 0.0f ? (diff -= 180.0f) : (diff += 180.0f);
            }
            double rad = Math.toRadians(diff);
            float px = 25.0f + (float)Math.sin(rad) * radius;
            float py = 25.0f - (float)Math.cos(rad) * radius;
            int drawX = Math.round(px - 2.5f);
            int drawY = Math.round(py - 2.5f);
            this.renderImage(drawX, drawY, 5, 5, COMPASS_POINT_MARKER);
        }
    }

    private static float wrapDegrees(float deg) {
        if ((deg %= 360.0f) >= 180.0f) {
            deg -= 360.0f;
        }
        if (deg < -180.0f) {
            deg += 360.0f;
        }
        return deg;
    }

    private float getAngleDifference(Player player, Coordinate coordinate) {
        Vec3 eyePos = player.m_20299_(1.0f);
        double dx = coordinate.x() - eyePos.f_82479_;
        double dz = coordinate.z() - eyePos.f_82481_;
        double targetYaw = Math.toDegrees(Math.atan2(dx, dz));
        float playerYaw = player.m_146908_();
        return QuestCompassHudElement.wrapDegrees((float)(-(targetYaw + (double)playerYaw)));
    }

    @Override
    protected void reset() {
        QuestCompassHudElement.clear();
    }
}

