/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.hud;

import com.equestricraft.common.Argb;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.quest.TrackedQuestDisplayInformation;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.hud.HudElement;
import java.time.Duration;

public class QuestHudElement
extends HudElement {
    private static TrackedQuestDisplayInformation trackedQuestDisplayInformation = null;
    private static Duration differenceWithServerTime = null;

    public static void setInfo(TrackedQuestDisplayInformation trackedQuestDisplayInformation) {
        QuestHudElement.trackedQuestDisplayInformation = trackedQuestDisplayInformation;
        if (trackedQuestDisplayInformation != null) {
            differenceWithServerTime = DateUtils.durationUntil(trackedQuestDisplayInformation.updateTime());
        }
    }

    @Override
    protected int getXPosition() {
        return 5;
    }

    @Override
    protected int getYPosition() {
        return 25;
    }

    @Override
    protected void render() {
        TrackedQuestDisplayInformation current = trackedQuestDisplayInformation;
        if (current != null) {
            int y = 0;
            this.renderString(0, y, current.questName(), Argb.ARGB_WHITE, 1.3f);
            y += (int)((double)GuiUtil.getStandardLineHeight() * 1.3) + 10;
            for (String objective : current.objectives()) {
                this.renderString(0, y, " - " + objective, Argb.ARGB_WHITE);
                y += GuiUtil.getStandardLineHeight() + 2;
            }
            if (current.timerEndTime() != null) {
                Duration durationUntil = DateUtils.durationUntil(current.timerEndTime());
                durationUntil = this.offsetToServerTime(durationUntil);
                String timerString = this.buildTimerString(durationUntil);
                Argb timerColor = this.determineTimerColor(durationUntil);
                this.renderString(0, y, timerString, timerColor);
                y += GuiUtil.getStandardLineHeight() + 2;
            }
            if (current.stopwatchStartTime() != null) {
                Duration durationSince = DateUtils.durationSince(current.stopwatchStartTime());
                durationSince = this.offsetToServerTime(durationSince);
                String stopwatchString = this.buildTimerString(durationSince);
                this.renderString(0, y, stopwatchString, Argb.ARGB_WHITE);
            }
        }
    }

    @Override
    protected void reset() {
        trackedQuestDisplayInformation = null;
        differenceWithServerTime = null;
    }

    public String buildTimerString(Duration duration) {
        duration = duration.plusSeconds(1L);
        long minutes = duration.toMinutes();
        long seconds = duration.minusMinutes(minutes).getSeconds();
        return String.format("%02d:%02d", minutes, seconds);
    }

    private Argb determineTimerColor(Duration duration) {
        Argb timerEndColor = trackedQuestDisplayInformation.timerEndColor();
        if (duration.toMillis() < 10000L) {
            return timerEndColor != null ? timerEndColor : Argb.ARGB_RED;
        }
        return Argb.ARGB_WHITE;
    }

    private Duration offsetToServerTime(Duration duration) {
        if (differenceWithServerTime != null) {
            return duration.plus(differenceWithServerTime);
        }
        return duration;
    }
}

