/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.hud;

import com.equestricraft.common.Argb;
import com.equestricraft.core.weather.CurrentWeather;
import com.equestricraft.core.weather.WeatherType;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.hud.HudElement;
import com.equestricraft.mod.util.ComponentUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class WeatherHudElement
extends HudElement {
    private static CurrentWeather currentWeather = null;
    private static TextComponent temperatureComponent = null;
    private static TextComponent windSpeedComponent = null;
    private static ResourceLocation weatherIconPath = null;

    public static void setWeatherInfo(CurrentWeather currentWeather) {
        WeatherHudElement.currentWeather = currentWeather;
        temperatureComponent = ComponentUtil.buildColoredTextComponent(currentWeather.temperatureFormatted());
        windSpeedComponent = ComponentUtil.buildColoredTextComponent(currentWeather.windSpeedFormatted());
        weatherIconPath = WeatherHudElement.getWeatherIcon(currentWeather);
    }

    @Override
    protected int getXPosition() {
        return 5;
    }

    @Override
    protected int getYPosition() {
        return 5;
    }

    @Override
    protected void render() {
        CurrentWeather current = currentWeather;
        if (current != null) {
            this.renderString(0, 0, temperatureComponent, Argb.ARGB_MC_AQUA);
            int temperatureWidth = GuiUtil.getStandardTextWidth((Component)temperatureComponent);
            this.renderString(temperatureWidth + 4, 0, windSpeedComponent, Argb.ARGB_MC_AQUA);
            int windSpeedWidth = GuiUtil.getStandardTextWidth((Component)windSpeedComponent);
            int imageSize = GuiUtil.getStandardLineHeight();
            this.renderImage(temperatureWidth + 4 + windSpeedWidth + 4, 0, imageSize, imageSize, weatherIconPath);
        }
    }

    @Override
    protected void reset() {
        currentWeather = null;
        temperatureComponent = null;
        windSpeedComponent = null;
        weatherIconPath = null;
    }

    private static ResourceLocation getWeatherIcon(CurrentWeather currentWeather) {
        if (currentWeather.freezing()) {
            return Resources.getTextures().getGui().get("ice.png");
        }
        if (currentWeather.fog()) {
            return Resources.getTextures().getGui().get("fog.png");
        }
        if (currentWeather.heatwave()) {
            return Resources.getTextures().getGui().get("thermometer.png");
        }
        if (currentWeather.snowing()) {
            return Resources.getTextures().getGui().get("snow.png");
        }
        if (currentWeather.highWinds()) {
            return Resources.getTextures().getGui().get("wind.png");
        }
        if (currentWeather.thunder()) {
            return Resources.getTextures().getGui().get("lightning.png");
        }
        return switch (currentWeather.weatherType()) {
            default -> throw new IncompatibleClassChangeError();
            case WeatherType.CLEAR -> Resources.getTextures().getGui().get("sun.png");
            case WeatherType.CLOUD -> Resources.getTextures().getGui().get("cloud.png");
            case WeatherType.RAIN -> Resources.getTextures().getGui().get("rain.png");
        };
    }
}

