/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.models;

import com.equestricraft.common.tack.HorseBonnetModel;
import com.equestricraft.common.tack.HorseBootsModel;
import com.equestricraft.common.tack.HorseBridleModel;
import com.equestricraft.common.tack.HorseCinchModel;
import com.equestricraft.common.tack.HorseGirthModel;
import com.equestricraft.common.tack.HorseHalterModel;
import com.equestricraft.common.tack.HorsePadModel;
import com.equestricraft.common.tack.HorseReinModel;
import com.equestricraft.common.tack.HorseSaddleModel;
import com.equestricraft.common.tack.HorseWrapsModel;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.models.HorseModelPart;
import com.equestricraft.mod.client.models.ModelHorseAnimation;
import com.equestricraft.mod.client.models.ModelHorseLayer;
import com.equestricraft.mod.util.AnimUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelHorse<T extends EntityHorse>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("equestricraft", "horse_entity"), "main");
    private final List<HorseModelPart> parts = new ArrayList<HorseModelPart>();
    private final List<HorseModelPart> topLevelParts = new ArrayList<HorseModelPart>();
    private ModelHorseAnimation activeAnimation = ModelHorseAnimation.RESTING_1;
    private ModelHorseAnimation previousAnimation = ModelHorseAnimation.RESTING_1;
    private static final float PI_OVER_180 = (float)Math.PI / 180;

    public ModelHorse(ModelPart root) {
        HorseModelPart rootPart = new HorseModelPart("root", root, true);
        HorseModelPart head = this.registerPart(rootPart, "head");
        this.topLevelParts.add(head);
        HorseModelPart leftEar = this.registerPart(head, "leftEar");
        this.registerPart(leftEar, "rightEar");
        HorseModelPart face = this.registerPart(head, "face");
        HorseModelPart muzzle = this.registerPart(face, "muzzle");
        this.registerPart(muzzle, "jaw");
        HorseModelPart body = this.registerPart(rootPart, "body");
        this.topLevelParts.add(body);
        this.registerPart(body, "torso");
        HorseModelPart neck = this.registerPart(body, "neck");
        this.registerPart(neck, "mane");
        HorseModelPart legFrontRight = this.registerPart(rootPart, "legFrontRight");
        this.topLevelParts.add(legFrontRight);
        this.registerPart(legFrontRight, "rightFrontLeg");
        this.registerPart(legFrontRight, "rightFLoweLeg");
        this.registerPart(legFrontRight, "rightFrontHoof");
        HorseModelPart legFrontLeft = this.registerPart(rootPart, "legFrontLeft");
        this.topLevelParts.add(legFrontLeft);
        this.registerPart(legFrontLeft, "leftFrontLeg");
        this.registerPart(legFrontLeft, "leftFLowerLeg");
        this.registerPart(legFrontLeft, "leftFrontHoof");
        HorseModelPart legBackRight = this.registerPart(rootPart, "legBackRight");
        this.topLevelParts.add(legBackRight);
        this.registerPart(legBackRight, "rightBackLeg");
        this.registerPart(legBackRight, "rightBLowerLeg");
        this.registerPart(legBackRight, "rightBackHoof");
        HorseModelPart legBackLeft = this.registerPart(rootPart, "legBackLeft");
        this.topLevelParts.add(legBackLeft);
        this.registerPart(legBackLeft, "leftBackLeg");
        this.registerPart(legBackLeft, "leftBLowerLeg");
        this.registerPart(legBackLeft, "leftBackHoof");
        HorseModelPart tail = this.registerPart(rootPart, "tail");
        this.topLevelParts.add(tail);
        this.registerPart(tail, "tailbone");
        this.registerPart(tail, "tailLower");
        this.registerPart(tail, "tailUpper");
        this.registerHiddenPart(rootPart, "horseRightRein");
        this.registerHiddenPart(rootPart, "horseLeftRein");
        this.registerHiddenPart(rootPart, "defaultSaddle");
        HorseModelPart maneVariations = this.registerHiddenPart(rootPart, "maneVariations");
        this.topLevelParts.add(maneVariations);
        this.registerPart(maneVariations, "showbraids");
        HorseModelPart tailVariations = this.registerHiddenPart(rootPart, "tailVariations");
        this.topLevelParts.add(tailVariations);
        this.registerPart(tailVariations, "shorttail");
        this.registerPart(tailVariations, "mediumtail");
        HorseModelPart mediumTail2 = this.registerHiddenPart(rootPart, "mediumtail2");
        this.topLevelParts.add(mediumTail2);
        HorseModelPart bridles = this.registerHiddenPart(rootPart, "bridles");
        this.topLevelParts.add(bridles);
        HorseModelPart engBridle = this.registerPart(bridles, "engBridle");
        this.registerPart(engBridle, "leather2");
        this.registerPart(engBridle, "buckle1");
        this.registerPart(engBridle, "buckle2");
        this.registerPart(engBridle, "buckle3");
        HorseModelPart bits = this.registerPart(engBridle, "bits");
        this.registerPart(bits, "ORingBit");
        this.registerPart(bits, "fullcheckBit");
        this.registerPart(bits, "eggbuttBit");
        this.registerPart(bits, "DRingengBit");
        HorseModelPart engBridleFlash = this.registerPart(bridles, "engBridleFlash");
        this.registerPart(engBridleFlash, "buckle7");
        this.registerPart(engBridleFlash, "buckle8");
        this.registerPart(engBridleFlash, "buckle10");
        HorseModelPart engBridleFigure8 = this.registerPart(bridles, "engBridleFigure8");
        this.registerPart(engBridleFigure8, "leather");
        this.registerPart(engBridleFigure8, "buckle4");
        this.registerPart(engBridleFigure8, "buckle5");
        this.registerPart(engBridleFigure8, "buckle6");
        this.registerPart(engBridleFigure8, "ring1");
        this.registerPart(engBridleFigure8, "ring2");
        this.registerPart(engBridleFigure8, "middlepiece");
        HorseModelPart shapedPad = this.registerHiddenPart(rootPart, "shapedPad");
        this.topLevelParts.add(shapedPad);
        HorseModelPart halfPad = this.registerHiddenPart(rootPart, "halfPad");
        this.topLevelParts.add(halfPad);
        this.registerPart(halfPad, "sheepskin2");
        this.registerPart(halfPad, "padding2");
        HorseModelPart englishPad = this.registerHiddenPart(rootPart, "englishPad");
        this.topLevelParts.add(englishPad);
        this.registerPart(englishPad, "topface");
        HorseModelPart luxEnglishPad = this.registerHiddenPart(rootPart, "LuxenglishPad");
        this.topLevelParts.add(luxEnglishPad);
        HorseModelPart custom3DEngSaddle = this.registerHiddenPart(rootPart, "custom3DEngSaddle");
        this.topLevelParts.add(custom3DEngSaddle);
        this.registerPart(custom3DEngSaddle, "stirrups");
        this.registerPart(custom3DEngSaddle, "stirrups2");
        this.registerPart(custom3DEngSaddle, "saddleflap");
        this.registerPart(custom3DEngSaddle, "saddleflap2");
        HorseModelPart custom3DDreSaddle = this.registerHiddenPart(rootPart, "custom3DDreSaddle");
        this.topLevelParts.add(custom3DDreSaddle);
        HorseModelPart saddleFlap3 = this.registerPart(custom3DDreSaddle, "saddleflap3");
        this.registerPart(saddleFlap3, "stirrups4");
        HorseModelPart custom3DSaddleseatSaddle = this.registerHiddenPart(rootPart, "custom3DSaddleseatSaddle");
        this.topLevelParts.add(custom3DSaddleseatSaddle);
        HorseModelPart engGirth = this.registerHiddenPart(rootPart, "engGirth");
        this.topLevelParts.add(engGirth);
        HorseModelPart engJumpGirth = this.registerHiddenPart(rootPart, "engJumpGirth");
        this.topLevelParts.add(engJumpGirth);
        HorseModelPart customWesternSaddle = this.registerHiddenPart(rootPart, "customWesternSaddle");
        this.topLevelParts.add(customWesternSaddle);
        this.registerPart(customWesternSaddle, "stirrups3");
        this.registerPart(customWesternSaddle, "stirrups5");
        this.registerPart(customWesternSaddle, "topface2");
        this.registerPart(customWesternSaddle, "detailing2");
        this.registerPart(customWesternSaddle, "edges");
        HorseModelPart customWesternPad = this.registerHiddenPart(rootPart, "customWesternPad");
        this.topLevelParts.add(customWesternPad);
        this.registerPart(customWesternPad, "topface3");
        HorseModelPart westernCinch = this.registerHiddenPart(rootPart, "WesternCinch");
        this.topLevelParts.add(westernCinch);
        HorseModelPart westernBridle = this.registerHiddenPart(rootPart, "westernBridle");
        this.topLevelParts.add(westernBridle);
        HorseModelPart bits2 = this.registerPart(westernBridle, "Bits2");
        this.registerPart(bits2, "westernBit2");
        this.registerPart(bits2, "westernBit1");
        this.registerPart(westernBridle, "buckle9");
        this.registerPart(westernBridle, "bone");
        this.registerPart(westernBridle, "bone2");
        HorseModelPart halter = this.registerHiddenPart(rootPart, "halter");
        this.topLevelParts.add(halter);
        this.registerPart(halter, "ring3");
        this.registerPart(halter, "ring5");
        this.registerPart(halter, "ring4");
        this.registerPart(halter, "buckle");
        HorseModelPart dressageBoots = this.registerHiddenPart(rootPart, "dressageBoots");
        this.topLevelParts.add(dressageBoots);
        this.registerPart(dressageBoots, "leftBootD");
        this.registerPart(dressageBoots, "rightBootD");
        HorseModelPart tendonBoots = this.registerHiddenPart(rootPart, "tendonBoots");
        this.topLevelParts.add(tendonBoots);
        this.registerPart(tendonBoots, "leftBoot");
        this.registerPart(tendonBoots, "rightBoot");
        HorseModelPart polowraps = this.registerHiddenPart(rootPart, "polowraps");
        this.topLevelParts.add(polowraps);
        this.registerPart(polowraps, "FLeft");
        this.registerPart(polowraps, "FRight");
        this.registerPart(polowraps, "BLeft");
        this.registerPart(polowraps, "BRight");
        HorseModelPart customRacingSaddle = this.registerHiddenPart(rootPart, "customRacingSaddle");
        this.topLevelParts.add(customRacingSaddle);
        this.registerPart(customRacingSaddle, "stirrups6");
        this.registerPart(customRacingSaddle, "stirrups7");
        this.registerPart(customRacingSaddle, "saddleflap4");
        this.registerPart(customRacingSaddle, "saddleflap5");
        HorseModelPart racingPad = this.registerHiddenPart(rootPart, "RacingPad");
        this.topLevelParts.add(racingPad);
        HorseModelPart bonnet = this.registerHiddenPart(rootPart, "bonnet");
        this.topLevelParts.add(bonnet);
    }

    private HorseModelPart registerPart(HorseModelPart parent, String name) {
        return this.registerPart(parent, name, true);
    }

    private HorseModelPart registerHiddenPart(HorseModelPart parent, String name) {
        return this.registerPart(parent, name, false);
    }

    private HorseModelPart registerPart(HorseModelPart parent, String name, boolean defaultShow) {
        ModelPart part = parent.getModelPart().m_171324_(name);
        HorseModelPart horseModelPart = new HorseModelPart(name, part, defaultShow);
        this.parts.add(horseModelPart);
        return horseModelPart;
    }

    public static LayerDefinition createBodyLayer() {
        return ModelHorseLayer.create();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void prepareMobModel(T entity, float limbSwingAmount, float limbSwing, float frameTime) {
        this.setTack(entity);
        ModelHorseAnimation animation = ModelHorseAnimation.valueOf(((EntityHorse)entity).getCurrentAnimation());
        float period = limbSwingAmount * animation.getSpeedFactor() * ((EntityHorse)entity).getCurrentGaitImpairmentFactor() / 10.0f;
        float movingPower = Math.min(limbSwing * 20.0f / animation.getSpeedFactor(), 1.0f);
        this.parts.forEach(part -> this.animate(entity, animation, (HorseModelPart)part, period, movingPower));
        if (((EntityHorse)entity).isJumpingPlayed()) {
            ((EntityHorse)entity).addJumpTime(frameTime / 25.0f);
        }
        if (animation != this.activeAnimation) {
            ((EntityHorse)entity).setRefTime(period);
            this.previousAnimation = this.activeAnimation;
            this.activeAnimation = animation;
        }
    }

    private void setTack(T entity) {
        HorseBonnetModel currentBonnet = ((EntityHorse)entity).getBonnetModel();
        for (HorseBonnetModel bonnet : HorseBonnetModel.values()) {
            HorseModelPart part = this.findPart(bonnet.getModelName());
            part.setShowing(bonnet.equals(currentBonnet));
        }
        HorseBootsModel currentBoots = ((EntityHorse)entity).getBootsModel();
        for (HorseBootsModel boots : HorseBootsModel.values()) {
            HorseModelPart part = this.findPart(boots.getModelName());
            part.setShowing(boots.equals(currentBoots));
        }
        HorseBridleModel currentBridle = ((EntityHorse)entity).getBridleModel();
        for (HorseBridleModel bridle : HorseBridleModel.values()) {
            HorseModelPart part = this.findPart(bridle.getModelName());
            part.setShowing(bridle.equals(currentBridle));
        }
        HorseCinchModel currentCinch = ((EntityHorse)entity).getCinchModel();
        for (HorseCinchModel cinch : HorseCinchModel.values()) {
            HorseModelPart part = this.findPart(cinch.getModelName());
            part.setShowing(cinch.equals(currentCinch));
        }
        HorseGirthModel currentGirth = ((EntityHorse)entity).getGirthModel();
        for (HorseGirthModel girth : HorseGirthModel.values()) {
            HorseModelPart part = this.findPart(girth.getModelName());
            part.setShowing(girth.equals(currentGirth));
        }
        HorseHalterModel currentHalter = ((EntityHorse)entity).getHalterModel();
        for (HorseHalterModel halter : HorseHalterModel.values()) {
            HorseModelPart part = this.findPart(halter.getModelName());
            part.setShowing(halter.equals(currentHalter));
        }
        HorsePadModel currentPad = ((EntityHorse)entity).getPadModel();
        for (HorsePadModel pad : HorsePadModel.values()) {
            HorseModelPart part = this.findPart(pad.getModelName());
            part.setShowing(pad.equals(currentPad));
        }
        HorseReinModel currentRein = ((EntityHorse)entity).getReinModel();
        for (HorseReinModel rein : HorseReinModel.values()) {
            HorseModelPart part = this.findPart(rein.getModelName());
            part.setShowing(rein.equals(currentRein));
        }
        HorseSaddleModel currentSaddle = ((EntityHorse)entity).getSaddleModel();
        for (HorseSaddleModel saddle : HorseSaddleModel.values()) {
            HorseModelPart part = this.findPart(saddle.getModelName());
            part.setShowing(saddle.equals(currentSaddle));
        }
        HorseWrapsModel currentWrapsModel = ((EntityHorse)entity).getWrapsModel();
        for (HorseWrapsModel wraps : HorseWrapsModel.values()) {
            HorseModelPart part = this.findPart(wraps.getModelName());
            part.setShowing(wraps.equals(currentWrapsModel));
        }
    }

    private HorseModelPart findPart(String name) {
        for (HorseModelPart part : this.parts) {
            if (!part.getName().equals(name)) continue;
            return part;
        }
        throw new IllegalArgumentException(String.format("Invalid horse model part: %s", name));
    }

    private void animate(T entity, ModelHorseAnimation animation, HorseModelPart horseModelPart, float period, float movingPower) {
        String name = horseModelPart.getName();
        ModelPart part = horseModelPart.getModelPart();
        PartPose initialPose = horseModelPart.getInitialPartPose();
        Vector3f rotationVector = this.getRotationVector(entity, period, movingPower, animation, name);
        Vector3f positionVector = this.getPositionVector(entity, period, movingPower, animation, name);
        if (rotationVector != null) {
            part.m_171327_(initialPose.f_171408_ + rotationVector.m_122239_() * ((float)Math.PI / 180), initialPose.f_171409_ + rotationVector.m_122260_() * ((float)Math.PI / 180), initialPose.f_171410_ + rotationVector.m_122269_() * ((float)Math.PI / 180));
        } else {
            part.m_171327_(initialPose.f_171408_, initialPose.f_171409_, initialPose.f_171410_);
        }
        if (positionVector != null) {
            part.m_104227_(initialPose.f_171405_ + positionVector.m_122239_(), initialPose.f_171406_ - positionVector.m_122260_(), initialPose.f_171407_ + positionVector.m_122269_());
        } else {
            part.m_104227_(initialPose.f_171405_, initialPose.f_171406_, initialPose.f_171407_);
        }
    }

    private Vector3f getRotationVector(T entity, float period, float movingPower, ModelHorseAnimation animation, String name) {
        Vector3f rot = null;
        if (movingPower > 0.0f) {
            Vector3f rot0;
            if (animation.hasRotationData(name) && (rot = animation.getModelPartRotation(name, period)) != null) {
                rot.m_122261_(movingPower);
            }
            if (animation != this.previousAnimation && this.previousAnimation != ModelHorseAnimation.RESTING_1 && this.previousAnimation.hasRotationData(name) && (rot0 = this.previousAnimation.getModelPartRotation(name, period)) != null) {
                rot0.m_122261_(movingPower);
                float blend = Mth.m_14036_((float)(period - ((EntityHorse)entity).getRefTime()), (float)0.0f, (float)1.0f);
                rot = this.blendVectors(rot, rot0, 1.0f - blend);
            }
        }
        if (((EntityHorse)entity).isJumpingPlayed()) {
            Vector3f jumpRot;
            float jumpTime = Mth.m_14036_((float)(((EntityHorse)entity).getJumpTime() / ((EntityHorse)entity).m_6118_()), (float)0.0f, (float)ModelHorseAnimation.REAR.getLength());
            if (jumpTime == ModelHorseAnimation.REAR.getLength()) {
                ((EntityHorse)entity).setJumpTime(AnimUtil.JUMP.getStartOffset() / 2.0f);
                ((EntityHorse)entity).setJumpingPlayed(false);
            } else if (ModelHorseAnimation.REAR.hasRotationData(name) && (jumpRot = ModelHorseAnimation.REAR.getModelPartRotation(name, jumpTime)) != null) {
                jumpRot.m_122261_(Math.min((float)Math.pow(((EntityHorse)entity).m_6118_(), 2.0) * 3.0f, 1.0f));
                float blend = AnimUtil.JUMP.bezierLerpInOut(jumpTime, ModelHorseAnimation.REAR.getLength());
                rot = this.blendVectors(rot, jumpRot, blend);
            }
        }
        return rot;
    }

    private Vector3f getPositionVector(T entity, float period, float movingPower, ModelHorseAnimation animation, String name) {
        float jumpTime;
        Vector3f jumpPos;
        Vector3f pos = null;
        if (movingPower > 0.0f) {
            Vector3f pos0;
            if (animation.hasPositionData(name) && (pos = animation.getModelPartLocation(name, period)) != null) {
                pos.m_122261_(movingPower);
            }
            if (animation != this.previousAnimation && this.previousAnimation != ModelHorseAnimation.RESTING_1 && this.previousAnimation.hasPositionData(name) && (pos0 = this.previousAnimation.getModelPartLocation(name, period)) != null) {
                pos0.m_122261_(movingPower);
                float blend = Mth.m_14036_((float)(period - ((EntityHorse)entity).getRefTime()), (float)0.0f, (float)1.0f);
                pos = this.blendVectors(pos, pos0, 1.0f - blend);
            }
        }
        if (((EntityHorse)entity).isJumpingPlayed() && ModelHorseAnimation.REAR.hasPositionData(name) && (jumpPos = ModelHorseAnimation.REAR.getModelPartLocation(name, jumpTime = Mth.m_14036_((float)(((EntityHorse)entity).getJumpTime() / ((EntityHorse)entity).m_6118_()), (float)0.0f, (float)ModelHorseAnimation.REAR.getLength()))) != null) {
            float blend = AnimUtil.JUMP.bezierLerpInOut(jumpTime, ModelHorseAnimation.REAR.getLength());
            jumpPos.m_122261_(Math.min((float)Math.pow(((EntityHorse)entity).m_6118_(), 2.0) * 3.0f, 1.0f));
            pos = this.blendVectors(pos, jumpPos, blend);
        }
        return pos;
    }

    private Vector3f blendVectors(Vector3f base, Vector3f other, float blend) {
        if (base == null) {
            Vector3f copy = other.m_122281_();
            copy.m_122261_(blend);
            return copy;
        }
        Vector3f copy = base.m_122281_();
        copy.m_122255_(other, blend);
        return copy;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (HorseModelPart p : this.topLevelParts) {
            if (!p.isShowing()) continue;
            p.getModelPart().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    private static Vector3f defaultVector() {
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }
}

