/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.models;

import com.equestricraft.mod.packet.ClientBoundAnimationSpeedFactorUpdatePacket;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum ModelHorseAnimation {
    GRAZING_1("grazing.json", 1.0f),
    PAWING_1("pawing.json", 1.0f),
    RESTING_1("resting.json", 1.0f),
    REAR("rear.json", 1.0f),
    PIAFFE("piaffe.json", 1.0f),
    WALK_STANDARD("walk_standard.json", 0.7f),
    JOG("job.json", 1.0f),
    LOPE_LEFT("lope_left.json", 1.0f),
    LOPE_RIGHT("lope_right.json", 1.0f),
    TROT_STANDARD("trot_standard.json", 1.0f),
    TROT_COLLECTED("trot_collected.json", 1.0f),
    TROT_PASSAGE("trot_passage.json", 1.0f),
    TROT_SPRINGY("trot_springy.json", 1.0f),
    CANTER_STANDARD_LEFT("canter_standard_left.json", 1.0f),
    CANTER_STANDARD_RIGHT("canter_standard_right.json", 1.0f),
    CANTER_COLLECTED_LEFT("canter_collected_left.json", 1.0f),
    CANTER_COLLECTED_RIGHT("canter_collected_right.json", 1.0f),
    GALLOP_STANDARD_LEFT("gallop_standard_left.json", 0.7f),
    GALLOP_STANDARD_RIGHT("gallop_standard_right.json", 0.7f),
    PACE_STANDARD("pace_standard.json", 1.0f);

    private float length = 1.0f;
    private float speedFactor;
    private final Map<String, Map<Float, Vector3f>> positionData = new HashMap<String, Map<Float, Vector3f>>();
    private final Map<String, Map<Float, Vector3f>> rotationData = new HashMap<String, Map<Float, Vector3f>>();

    private ModelHorseAnimation(String file, float speedFactor) {
        this.read(file);
        this.speedFactor = speedFactor;
    }

    public float getLength() {
        return this.length;
    }

    public float getSpeedFactor() {
        return this.speedFactor;
    }

    void setSpeedFactor(float speedFactor) {
        this.speedFactor = speedFactor;
    }

    public boolean hasPositionData(String part) {
        return this.positionData.containsKey(part);
    }

    public boolean hasRotationData(String part) {
        return this.rotationData.containsKey(part);
    }

    public Vector3f getModelPartLocation(String part, float period) {
        return this.getValues(period % this.length, this.positionData.get(part));
    }

    public Vector3f getModelPartRotation(String part, float period) {
        return this.getValues(period % this.length, this.rotationData.get(part));
    }

    private Vector3f getValues(float time, Map<Float, Vector3f> keyframes) {
        float firstKey;
        if (keyframes == null || keyframes.isEmpty()) {
            return null;
        }
        float secondKey = firstKey = 999.9f;
        List sortedKeys = keyframes.keySet().stream().sorted().toList();
        for (int i = 0; i < sortedKeys.size(); ++i) {
            Float key = (Float)sortedKeys.get(i);
            if (!(Math.abs(key.floatValue() - time) < Math.abs(firstKey - time))) continue;
            firstKey = key.floatValue();
            if (time - firstKey > 0.0f) {
                if (i + 1 < sortedKeys.size()) {
                    secondKey = ((Float)sortedKeys.get(i + 1)).floatValue();
                    continue;
                }
                secondKey = firstKey;
                continue;
            }
            if (time - firstKey < 0.0f) {
                if (i - 1 >= 0) {
                    secondKey = ((Float)sortedKeys.get(i - 1)).floatValue();
                    continue;
                }
                secondKey = firstKey;
                continue;
            }
            secondKey = firstKey;
        }
        Vector3f result = keyframes.get(Float.valueOf(firstKey));
        if (result == null) {
            return null;
        }
        result = result.m_122281_();
        if (secondKey == firstKey) {
            return result;
        }
        float mul = (float)((double)Math.abs(firstKey - time) * (1.0 / (double)Math.abs(firstKey - secondKey)));
        result.m_122255_(keyframes.get(Float.valueOf(secondKey)), mul);
        return result;
    }

    private void read(String fileName) {
        try {
            ResourceLocation location = new ResourceLocation("equestricraft", "animations/horse/" + fileName);
            InputStream in = Minecraft.m_91087_().m_91098_().m_142591_(location).m_6679_();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            JsonObject animationData = ((JsonElement)new Gson().fromJson((Reader)reader, JsonElement.class)).getAsJsonObject();
            this.length = animationData.get("length").getAsFloat();
            JsonArray animations = animationData.getAsJsonArray("animations");
            if (animations == null) {
                throw new IllegalArgumentException("Unable to read horse animation data");
            }
            for (int i = 0; i < animations.size(); ++i) {
                JsonElement animation = animations.get(i);
                String bone = animation.getAsJsonObject().get("bone").getAsString();
                JsonArray keyframes = animation.getAsJsonObject().get("keyframes").getAsJsonArray();
                HashMap<Float, Vector3f> targets = new HashMap<Float, Vector3f>();
                for (int j = 0; j < keyframes.size(); ++j) {
                    JsonElement keyframe = keyframes.get(j);
                    float timeStamp = keyframe.getAsJsonObject().get("timestamp").getAsFloat();
                    JsonArray target = keyframe.getAsJsonObject().get("target").getAsJsonArray();
                    targets.put(Float.valueOf(timeStamp), new Vector3f(target.get(0).getAsFloat(), target.get(1).getAsFloat(), target.get(2).getAsFloat()));
                }
                if (animation.getAsJsonObject().get("target").getAsString().equals("position")) {
                    this.positionData.put(bone, targets);
                    continue;
                }
                if (!animation.getAsJsonObject().get("target").getAsString().equals("rotation")) continue;
                this.rotationData.put(bone, targets);
            }
            reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void processUpdates(ClientBoundAnimationSpeedFactorUpdatePacket updatePacket) {
        for (Map.Entry<String, Float> entry : updatePacket.getSpeedFactorsMap().entrySet()) {
            ModelHorseAnimation enumValue = ModelHorseAnimation.valueOf(entry.getKey());
            enumValue.setSpeedFactor(entry.getValue().floatValue());
        }
    }
}

