/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.renderers;

import com.equestricraft.mod.client.bucket.EntityBucket;
import com.equestricraft.mod.client.models.ModelBucket;
import com.equestricraft.mod.provision.ProvisionContainerContentType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class EntityBucketRenderer<T extends EntityBucket>
extends MobRenderer<T, ModelBucket<T>> {
    private static final ResourceLocation EMPTY_BUCKET_TEXTURE = new ResourceLocation("equestricraft", "textures/entities/bucket/bucket.png");
    private static final ResourceLocation FEED_BUCKET_TEXTURE = new ResourceLocation("equestricraft", "textures/entities/bucket/feed_bucket.png");
    private static final ResourceLocation WATER_BUCKET_TEXTURE = new ResourceLocation("equestricraft", "textures/entities/bucket/water_bucket.png");

    public EntityBucketRenderer(EntityRendererProvider.Context context) {
        super(context, new ModelBucket(context.m_174023_(ModelBucket.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (((EntityBucket)entity).getQuantity() <= 0.0f) {
            return EMPTY_BUCKET_TEXTURE;
        }
        return switch (((EntityBucket)entity).getContentType()) {
            default -> throw new IncompatibleClassChangeError();
            case ProvisionContainerContentType.FEED -> FEED_BUCKET_TEXTURE;
            case ProvisionContainerContentType.WATER -> WATER_BUCKET_TEXTURE;
        };
    }
}

