/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.renderers;

import com.equestricraft.mod.client.PlayerData;
import com.equestricraft.mod.client.PlayerVisibilityController;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.client.horse.HorseTextureCombiner;
import com.equestricraft.mod.client.models.ModelHorse;
import com.equestricraft.mod.client.renderers.HorseCombinedTexturesCache;
import com.equestricraft.mod.client.renderers.HorseTextureLocationsCache;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class EntityHorseRenderer<T extends EntityHorse>
extends MobRenderer<T, ModelHorse<T>> {
    private final HorseTextureLocationsCache horseTextureLocationsCache = HorseTextureLocationsCache.getInstance();
    private final HorseCombinedTexturesCache horseCombinedTexturesCache = HorseCombinedTexturesCache.getInstance();
    private static final ResourceLocation DEFAULT_HORSE_TEXTURE = new ResourceLocation("equestricraft", EntityHorseRenderer.getPath("default"));

    public EntityHorseRenderer(EntityRendererProvider.Context context) {
        super(context, new ModelHorse(context.m_174023_(ModelHorse.LAYER_LOCATION)), 0.5f);
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (PlayerVisibilityController.isHideOtherPlayers() && ((EntityHorse)entity).getHorseEntityType() == HorseEntityType.STANDARD && ((EntityHorse)entity).getOwnerId() != PlayerData.getInternalId()) {
            return;
        }
        float scale = ((EntityHorse)entity).getModelScaleAtSpawn();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        super.m_7392_(entity, yaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(T entity) {
        String colorName = ((EntityHorse)entity).getColorName();
        String patternNames = ((EntityHorse)entity).getPatternNames();
        String grayName = ((EntityHorse)entity).getGrayName();
        String textureOverride = ((EntityHorse)entity).getTextureBase64();
        if (!textureOverride.isEmpty()) {
            Optional<ResourceLocation> resource = this.horseTextureLocationsCache.getOverrideLocation(((EntityHorse)entity).getInternalId(), () -> textureOverride);
            return resource.orElse(DEFAULT_HORSE_TEXTURE);
        }
        return this.horseCombinedTexturesCache.getCombinedTexture(colorName, patternNames, grayName, () -> this.createResource(colorName, patternNames, grayName));
    }

    private ResourceLocation createResource(String colorName, String patternNames, String grayName) {
        ResourceLocation colorResource = this.horseTextureLocationsCache.getCoreLocation(colorName, () -> new ResourceLocation("equestricraft", EntityHorseRenderer.getPath("colors/" + colorName)));
        ArrayList<ResourceLocation> patternResources = new ArrayList<ResourceLocation>();
        for (String pattern : patternNames.split(",")) {
            String name = pattern.isBlank() ? "none" : pattern.toLowerCase();
            ResourceLocation patternResource = this.horseTextureLocationsCache.getCoreLocation(patternNames, () -> new ResourceLocation("equestricraft", EntityHorseRenderer.getPath("styles/" + name)));
            patternResources.add(patternResource);
        }
        ResourceLocation grayResource = grayName.isEmpty() ? null : this.horseTextureLocationsCache.getCoreLocation(grayName, () -> new ResourceLocation("equestricraft", EntityHorseRenderer.getPath("colors/" + grayName)));
        NativeImage nativeImage = HorseTextureCombiner.createNativeImage(colorResource, patternResources, grayResource);
        DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
        return Minecraft.m_91087_().m_91097_().m_118490_("horse", dynamicTexture);
    }

    private static String getPath(String textureName) {
        return String.format("textures/entities/horse/%s.png", textureName);
    }
}

