/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.renderers;

import com.equestricraft.mod.client.npc.EntityNPC;
import com.equestricraft.mod.client.renderers.HumanNPCTextureLocationsCache;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;

public class EntityNPCRenderer<T extends EntityNPC>
extends LivingEntityRenderer<T, PlayerModel<T>> {
    private final HumanNPCTextureLocationsCache humanNpcTextureLocationsCache = HumanNPCTextureLocationsCache.getInstance();
    private static final ResourceLocation DEFAULT_NPC_TEXTURE = new ResourceLocation("equestricraft", "textures/entity/npc/default.png");

    public EntityNPCRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false), 0.5f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        Optional<ResourceLocation> resource = this.humanNpcTextureLocationsCache.get(((EntityNPC)entity).getInternalId(), () -> entity.getTextureBase64());
        return resource.orElse(DEFAULT_NPC_TEXTURE);
    }
}

