/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.renderers;

import com.equestricraft.common.util.ImageUtil;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.client.NativeImageConverter;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class HorseTextureLocationsCache {
    private static HorseTextureLocationsCache horseTextureLocationsCache = null;
    private final Map<String, ResourceLocation> coreResourceLocationMap = new HashMap<String, ResourceLocation>();
    private final Map<Integer, ResourceLocation> textureOverrideMap = new HashMap<Integer, ResourceLocation>();
    private static final Log log = Log.getLogger(HorseTextureLocationsCache.class.getName());

    public static synchronized HorseTextureLocationsCache getInstance() {
        if (horseTextureLocationsCache == null) {
            horseTextureLocationsCache = new HorseTextureLocationsCache();
        }
        return horseTextureLocationsCache;
    }

    private HorseTextureLocationsCache() {
    }

    public synchronized ResourceLocation getCoreLocation(String name, Supplier<ResourceLocation> defaultSupplier) {
        if (this.coreResourceLocationMap.containsKey(name)) {
            return this.coreResourceLocationMap.get(name);
        }
        ResourceLocation defaultValue = defaultSupplier.get();
        this.coreResourceLocationMap.put(name, defaultValue);
        return defaultValue;
    }

    public synchronized Optional<ResourceLocation> getOverrideLocation(int horseId, Supplier<String> base64Supplier) {
        ResourceLocation resource = this.textureOverrideMap.get(horseId);
        if (resource != null) {
            return Optional.of(resource);
        }
        String defaultValue = base64Supplier.get();
        if (defaultValue.isEmpty()) {
            return Optional.empty();
        }
        try {
            ResourceLocation resourceLocation = this.buildDynamicResource(defaultValue);
            this.textureOverrideMap.put(horseId, resourceLocation);
            return Optional.of(resourceLocation);
        }
        catch (IOException ex) {
            log.error("Error rendering horse texture", ex);
            return Optional.empty();
        }
    }

    private ResourceLocation buildDynamicResource(String defaultValue) throws IOException {
        BufferedImage image = ImageUtil.decodeFromBase64(defaultValue);
        NativeImage nativeImage = NativeImageConverter.createNativeImage(image);
        DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
        return Minecraft.m_91087_().m_91097_().m_118490_("horse", dynamicTexture);
    }
}

