/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.renderers;

import com.equestricraft.common.util.ImageUtil;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.client.NativeImageConverter;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class HumanNPCTextureLocationsCache {
    private static final HumanNPCTextureLocationsCache instance = new HumanNPCTextureLocationsCache();
    private final Map<Integer, ResourceLocation> resourceLocationMap = new HashMap<Integer, ResourceLocation>();
    private static final Log log = Log.getLogger(HumanNPCTextureLocationsCache.class.getName());

    public static HumanNPCTextureLocationsCache getInstance() {
        return instance;
    }

    private HumanNPCTextureLocationsCache() {
    }

    public synchronized Optional<ResourceLocation> get(int npcId, Supplier<String> base64Supplier) {
        ResourceLocation resource = this.resourceLocationMap.get(npcId);
        if (resource != null) {
            return Optional.of(resource);
        }
        String defaultValue = base64Supplier.get();
        if (defaultValue.isEmpty()) {
            return Optional.empty();
        }
        try {
            ResourceLocation resourceLocation = this.buildDynamicResource(defaultValue);
            this.resourceLocationMap.put(npcId, resourceLocation);
            return Optional.of(resourceLocation);
        }
        catch (IOException ex) {
            log.error("Error rendering NPC texture", ex);
            return Optional.empty();
        }
    }

    private ResourceLocation buildDynamicResource(String defaultValue) throws IOException {
        BufferedImage image = ImageUtil.decodeFromBase64(defaultValue);
        NativeImage nativeImage = NativeImageConverter.createNativeImage(image);
        DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
        return Minecraft.m_91087_().m_91097_().m_118490_("npc", dynamicTexture);
    }

    public void clearCache() {
        this.resourceLocationMap.clear();
    }
}

