/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.club;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.club.ClubRepository;
import com.equestricraft.core.club.member.ClubMemberInfo;
import com.equestricraft.core.club.member.ClubMemberSession;
import com.equestricraft.mod.club.ClubMemberPage;
import com.equestricraft.mod.club.ClubMemberPageService;
import java.util.Comparator;
import java.util.List;

public class ClubMemberPageServiceImpl
extends Pagination<ClubMemberInfo, ClubMemberPage, Object, Object>
implements ClubMemberPageService {
    @Service
    private ClubMemberSession clubMemberSession;
    @Service
    private ClubRepository clubRepository;
    private static final int MAXIMUM_PER_PAGE = 8;

    @Override
    public ClubMemberPage retrieveClubMemberPage(int clubId, int pageNumber) {
        Club club = (Club)this.clubRepository.findByKey(clubId);
        List<ClubMemberInfo> members = this.clubMemberSession.retrieveAllClubsMembers(club);
        return (ClubMemberPage)this.paginate(members, pageNumber, SortDirection.ASCENDING, null, null);
    }

    @Override
    protected int getMaximumPerPage() {
        return 8;
    }

    @Override
    protected boolean filter(ClubMemberInfo item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<ClubMemberInfo> compare(Object sortOrderObject) {
        return Comparator.comparing(i -> i.player().ign());
    }

    @Override
    protected ClubMemberPage buildPage(List<ClubMemberInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new ClubMemberPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

