/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.club;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.club.ClubInfo;
import com.equestricraft.core.club.ClubSession;
import com.equestricraft.mod.club.ClubPage;
import com.equestricraft.mod.club.ClubPageService;
import java.util.Comparator;
import java.util.List;

public class ClubPageServiceImpl
extends Pagination<ClubInfo, ClubPage, Object, Object>
implements ClubPageService {
    @Service
    private ClubSession clubSession;
    private static final int MAXIMUM_PER_PAGE = 4;

    @Override
    public ClubPage retrievePage(int pageNumber) {
        List<ClubInfo> clubs = this.clubSession.getAllClubs();
        return (ClubPage)this.paginate(clubs, pageNumber, SortDirection.ASCENDING, null, null);
    }

    @Override
    protected int getMaximumPerPage() {
        return 4;
    }

    @Override
    protected boolean filter(ClubInfo item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<ClubInfo> compare(Object sortOrderObject) {
        return Comparator.comparing(ClubInfo::clubName);
    }

    @Override
    protected ClubPage buildPage(List<ClubInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new ClubPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

