/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.club;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.club.rank.ClubRankInfo;
import com.equestricraft.core.club.rank.ClubRankSession;
import com.equestricraft.mod.club.ClubRankPage;
import com.equestricraft.mod.club.ClubRankPageService;
import java.util.Comparator;
import java.util.List;

public class ClubRankPageServiceImpl
extends Pagination<ClubRankInfo, ClubRankPage, Object, Object>
implements ClubRankPageService {
    @Service
    private ClubRankSession clubRankSession;
    private static final int MAXIMUM_PER_PAGE = 8;

    @Override
    public ClubRankPage retrieveRankPage(int clubId, int pageNumber) {
        List<ClubRankInfo> ranks = this.clubRankSession.retrieveAllClubsRanks(clubId);
        return (ClubRankPage)this.paginate(ranks, pageNumber, SortDirection.ASCENDING, null, null);
    }

    @Override
    protected int getMaximumPerPage() {
        return 8;
    }

    @Override
    protected boolean filter(ClubRankInfo item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<ClubRankInfo> compare(Object sortOrderObject) {
        return Comparator.comparing(ClubRankInfo::rankName);
    }

    @Override
    protected ClubRankPage buildPage(List<ClubRankInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new ClubRankPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

