/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.club;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.CannotSendClubJoinRequestException;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.club.ClubCreateException;
import com.equestricraft.core.club.ClubCreateResponse;
import com.equestricraft.core.club.ClubCreateSession;
import com.equestricraft.core.club.ClubJoinRequestException;
import com.equestricraft.core.club.ClubManageInfo;
import com.equestricraft.core.club.ClubNameUpdateException;
import com.equestricraft.core.club.ClubPermission;
import com.equestricraft.core.club.ClubPermissionChecker;
import com.equestricraft.core.club.ClubPermissionException;
import com.equestricraft.core.club.ClubRankException;
import com.equestricraft.core.club.ClubSession;
import com.equestricraft.core.club.ClubSettings;
import com.equestricraft.core.club.ClubTagUpdateException;
import com.equestricraft.core.club.PlayerNotClubAdminException;
import com.equestricraft.core.club.PlayerNotInClubException;
import com.equestricraft.core.club.joinrequest.ClubJoinRequestSession;
import com.equestricraft.core.club.rank.ClubPermissionLevel;
import com.equestricraft.core.club.rank.ClubRank;
import com.equestricraft.core.club.rank.ClubRankInfo;
import com.equestricraft.core.club.rank.ClubRankRepository;
import com.equestricraft.core.club.rank.ClubRankSession;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.economy.account.CannotUpdateAccountException;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.mod.club.ClubJoinInvitePage;
import com.equestricraft.mod.club.ClubJoinInvitePageService;
import com.equestricraft.mod.club.ClubJoinRequestPage;
import com.equestricraft.mod.club.ClubJoinRequestPageService;
import com.equestricraft.mod.club.ClubMemberPage;
import com.equestricraft.mod.club.ClubMemberPageService;
import com.equestricraft.mod.club.ClubPage;
import com.equestricraft.mod.club.ClubPageService;
import com.equestricraft.mod.club.ClubRankPage;
import com.equestricraft.mod.club.ClubRankPageService;
import com.equestricraft.mod.club.ClubService;
import com.equestricraft.mod.packet.ClientBoundClubEditMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundClubJoinInvitePageOpenPacket;
import com.equestricraft.mod.packet.ClientBoundClubJoinRequestPageOpenPacket;
import com.equestricraft.mod.packet.ClientBoundClubMemberPageOpenPacket;
import com.equestricraft.mod.packet.ClientBoundClubOfficeMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundClubPageOpenMenuPacket;
import com.equestricraft.mod.packet.ClientBoundClubRankPageScreenOpenPacket;
import com.equestricraft.mod.packet.ClientBoundManageClubInfoMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.OptionPromptItem;
import com.equestricraft.mod.prompt.PlayerSearchPrompt;
import com.equestricraft.mod.prompt.SingleSelectionOptionPrompt;
import com.equestricraft.mod.prompt.TextInputPrompt;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ClubServiceImpl
implements ClubService {
    @Service
    private ClubSession clubSession;
    @Service
    private ClubCreateSession clubCreateSession;
    @Service
    private ClubJoinRequestSession clubJoinRequestSession;
    @Service
    private ClubPageService clubPageService;
    @Service
    private ClubJoinRequestPageService clubJoinRequestPageService;
    @Service
    private ClubJoinInvitePageService clubJoinInvitePageService;
    @Service
    private ClubMemberPageService clubMemberPageService;
    @Service
    private ClubRankPageService clubRankPageService;
    @Service
    private ClubRankSession clubRankSession;
    @Service
    private ClubRankRepository clubRankRepository;
    @Service
    private PlayerRepository playerRepository;

    @Override
    public void showClubOfficeMenu(OnlinePlayer player) {
        Optional<Club> club = player.getClub().getClub();
        boolean canCreateClub = !this.clubSession.doesPlayerOwnClub(player) && this.clubSession.isPlayerHighEnoughRankToCreateClub(player) && club.isEmpty();
        boolean canManageClub = club.isPresent() && (player.getClub().isClubOwner() || player.getClub().getRank().map(ClubRank::getPermissionLevel).filter(ClubPermissionLevel::hasAnyPermission).isPresent());
        String formattedCost = EconomyUtilities.formatCurrency(ClubSettings.getCreatePrice().intValue());
        ClientBoundClubOfficeMenuOpenPacket packet = new ClientBoundClubOfficeMenuOpenPacket(canCreateClub, canManageClub, formattedCost);
        player.sendPacket(packet);
    }

    @Override
    public Response showClubEditMenu(OnlinePlayer player) {
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.EDIT_DETAILS);
            Club club = player.getClub().getClub().orElseThrow();
            ClientBoundClubEditMenuOpenPacket packet = new ClientBoundClubEditMenuOpenPacket(club.getId(), club.getName(), club.getChatTag());
            player.sendPacket(packet);
            return ResponseFactory.success();
        }
        catch (ClubPermissionException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex);
        }
    }

    @Override
    public Response updateClubDetails(OnlinePlayer player, String clubName, String clubTag) {
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.EDIT_DETAILS);
            Club club = player.getClub().getClub().orElseThrow();
            this.clubSession.updateClubName(club, clubName);
            this.clubSession.updateClubTag(club, clubTag);
            return ResponseFactory.success(I18n.getLabel("club.title"), I18n.getLabel("club.edit.success"), () -> this.showClubManageMenu(player));
        }
        catch (ClubNameUpdateException | ClubPermissionException | ClubTagUpdateException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex);
        }
    }

    @Override
    public void showClubPageMenu(OnlinePlayer onlinePlayer, int pageNumber) {
        ClubPage page = this.clubPageService.retrievePage(pageNumber);
        ClientBoundClubPageOpenMenuPacket packet = new ClientBoundClubPageOpenMenuPacket(page);
        onlinePlayer.sendPacket(packet);
    }

    @Override
    public Response showClubManageMenu(OnlinePlayer onlinePlayer) {
        Optional<ClubManageInfo> info2 = this.clubSession.getClubManageInfo(onlinePlayer);
        if (info2.isPresent()) {
            ClientBoundManageClubInfoMenuOpenPacket packet = new ClientBoundManageClubInfoMenuOpenPacket(info2.get());
            onlinePlayer.sendPacket(packet);
            return ResponseFactory.success();
        }
        return ResponseFactory.fail(I18n.getLabel("club.title"), I18n.getLabel("club.not-in-a-club"));
    }

    @Override
    public void showClubJoinRequestsMenu(OnlinePlayer onlinePlayer, int clubId, int pageNumber) {
        ClubJoinRequestPage page = this.clubJoinRequestPageService.retrieveJoinRequestPage(clubId, pageNumber);
        ClientBoundClubJoinRequestPageOpenPacket packet = new ClientBoundClubJoinRequestPageOpenPacket(clubId, page);
        onlinePlayer.sendPacket(packet);
    }

    @Override
    public void showClubJoinInvitesRequestsMenu(OnlinePlayer onlinePlayer, int pageNumber) {
        ClubJoinInvitePage page = this.clubJoinInvitePageService.retrieveJoinRequestPage(onlinePlayer, pageNumber);
        ClientBoundClubJoinInvitePageOpenPacket packet = new ClientBoundClubJoinInvitePageOpenPacket(page);
        onlinePlayer.sendPacket(packet);
    }

    @Override
    public void showClubMembersMenu(OnlinePlayer onlinePlayer, int clubId, int pageNumber) {
        ClubMemberPage page = this.clubMemberPageService.retrieveClubMemberPage(clubId, pageNumber);
        ClientBoundClubMemberPageOpenPacket packet = new ClientBoundClubMemberPageOpenPacket(clubId, page);
        onlinePlayer.sendPacket(packet);
    }

    @Override
    public void showClubRankPage(OnlinePlayer onlinePlayer, int clubId, int pageNumber) {
        ClubRankPage page = this.clubRankPageService.retrieveRankPage(clubId, pageNumber);
        ClientBoundClubRankPageScreenOpenPacket packet = new ClientBoundClubRankPageScreenOpenPacket(clubId, page);
        onlinePlayer.sendPacket(packet);
    }

    @Override
    public Response setAllowJoinRequests(OnlinePlayer player, boolean allow) {
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.EDIT_DETAILS);
            Club club = player.getClub().getClub().orElseThrow();
            club.setAllowJoinRequests(allow);
            club.save();
            return ResponseFactory.success(I18n.getLabel("club.allow-join-requests.toggle.success.title"), I18n.getLabel(allow ? "club.allow-join-requests.turned-on.success.message" : "club.allow-join-requests.turned-off.success.message"), () -> this.showClubManageMenu(player));
        }
        catch (ClubPermissionException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), (Exception)ex, () -> this.showClubManageMenu(player));
        }
    }

    @Override
    public Response createClub(OnlinePlayer player, String clubName, String chatTag) {
        try {
            ClubCreateResponse response = this.clubCreateSession.createClub(player, clubName, chatTag);
            return ResponseFactory.success(I18n.getLabel("club.create.success.prompt.title"), I18n.getLabel("club.create.success.message", response.club().getName(), response.cost(), response.newBalance()), () -> this.showClubManageMenu(player));
        }
        catch (ClubCreateException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.create.fail.title"), ex.getMessage(), () -> this.showClubOfficeMenu(player));
        }
    }

    @Override
    public Response sendJoinRequest(OnlinePlayer sendingPlayer, int receivingClubId) {
        try {
            Optional<String> message = TextInputPrompt.showTextInputPrompt(sendingPlayer, I18n.getLabel("club.send-join-request.message.prompt.title"), I18n.getLabel("club.send-join-request.message.prompt.message"));
            if (message.isPresent()) {
                this.clubJoinRequestSession.sendJoinRequest(sendingPlayer, receivingClubId, message.get());
                return ResponseFactory.success(I18n.getLabel("club.send-join-request.success.prompt.title"), I18n.getLabel("club.send-join-request.success.prompt.message"), () -> this.showClubPageMenu(sendingPlayer, 1));
            }
            return ResponseFactory.fail();
        }
        catch (CannotSendClubJoinRequestException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), (Exception)ex, () -> this.showClubPageMenu(sendingPlayer, 1));
        }
    }

    @Override
    public Response approveJoinRequest(OnlinePlayer player, int playerId) {
        Club club = player.getClub().getClub().orElseThrow();
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.MANAGE_JOIN_REQUESTS);
            CorePlayer playerToApprove = (CorePlayer)this.playerRepository.findByKey(playerId);
            this.clubJoinRequestSession.approveRequest(club, playerToApprove);
            return ResponseFactory.success(I18n.getLabel("club.join-requests.accept.title"), I18n.getLabel("club.join-requests.accept.message"), () -> this.showClubJoinRequestsMenu(player, club.getId(), 1));
        }
        catch (ClubJoinRequestException | ClubPermissionException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex, () -> this.showClubJoinRequestsMenu(player, club.getId(), 1));
        }
    }

    @Override
    public Response denyJoinRequest(OnlinePlayer player, int playerId) {
        Club club = player.getClub().getClub().orElseThrow();
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.MANAGE_JOIN_REQUESTS);
            Optional<String> message = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("club.join-requests.deny.message.prompt.title"), I18n.getLabel("club.join-requests.deny.message.prompt.message"));
            if (message.isPresent()) {
                CorePlayer playerToDeny = (CorePlayer)this.playerRepository.findByKey(playerId);
                this.clubJoinRequestSession.denyRequest(club, playerToDeny, message.get());
                return ResponseFactory.success(I18n.getLabel("club.join-requests.deny.title"), I18n.getLabel("club.join-requests.deny.message"), () -> this.showClubJoinRequestsMenu(player, club.getId(), 1));
            }
            return ResponseFactory.fail();
        }
        catch (ClubJoinRequestException | ClubPermissionException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex, () -> this.showClubJoinRequestsMenu(player, club.getId(), 1));
        }
    }

    @Override
    public Response createJoinInvite(OnlinePlayer player) {
        try {
            Optional<String> message;
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.SEND_INVITES);
            Optional<ECPlayer> receivingPlayer = PlayerSearchPrompt.showPlayerSearchPrompt(player);
            if (receivingPlayer.isPresent() && (message = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("club.send-invite.prompt.title"), I18n.getLabel("club.send-invite.prompt.message"))).isPresent()) {
                Club club = player.getClub().getClub().orElseThrow();
                this.clubJoinRequestSession.sendJoinInvite(club, receivingPlayer.get(), message.get());
                return ResponseFactory.success(I18n.getLabel("club.title"), I18n.getLabel("club.send-invite.success.message", receivingPlayer.get().getIgn()), () -> this.showClubManageMenu(player));
            }
            return ResponseFactory.fail();
        }
        catch (CannotSendClubJoinRequestException | ClubPermissionException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex, () -> this.showClubManageMenu(player));
        }
    }

    @Override
    public Response acceptInvite(OnlinePlayer player, int clubId) {
        try {
            this.clubJoinRequestSession.acceptInvite(player, clubId);
            return ResponseFactory.success(I18n.getLabel("club.invite.accept.success.title"), I18n.getLabel("club.invite.accept.success.message"));
        }
        catch (ClubJoinRequestException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex);
        }
    }

    @Override
    public Response denyInvite(OnlinePlayer player, int clubId) {
        try {
            Optional<String> message = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("club.invite.deny.message.prompt.title"), I18n.getLabel("club.invite.deny.message.prompt.message"));
            if (message.isPresent()) {
                this.clubJoinRequestSession.denyInvite(player, clubId, message.get());
                return ResponseFactory.success(I18n.getLabel("club.invite.deny.success.title"), I18n.getLabel("club.invite.deny.success.message"));
            }
            return ResponseFactory.fail();
        }
        catch (ClubJoinRequestException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex);
        }
    }

    @Override
    public Response kickMember(OnlinePlayer player, int playerToKickId) {
        Club club = player.getClub().getClub().orElseThrow();
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.MANAGE_MEMBERS);
            ConfirmResponse confirm = player.getConfirmation().confirm(I18n.getLabel("club.kick-member.confirm.title"), I18n.getLabel("club.kick-member.confirm.message"));
            if (confirm.isYes()) {
                CorePlayer playerToKick = (CorePlayer)this.playerRepository.findByKey(playerToKickId);
                playerToKick.getClub().removeFromClub(club);
                return ResponseFactory.success(I18n.getLabel("club.kick-member.success.title"), I18n.getLabel("club.kick-member.success.message"), () -> this.showClubMembersMenu(player, club.getId(), 1));
            }
            return ResponseFactory.fail();
        }
        catch (ClubPermissionException | PlayerNotInClubException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex, () -> this.showClubMembersMenu(player, club.getId(), 1));
        }
    }

    @Override
    public Response setPlayersRank(OnlinePlayer player, int playerId) {
        Club club = player.getClub().getClub().orElseThrow();
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.MANAGE_MEMBERS);
            List<ClubRankInfo> items = this.clubRankSession.retrieveAllClubsRanks(club.getId());
            Optional<ClubRankInfo> rank = SingleSelectionOptionPrompt.showOptionPrompt(player, items, this::buildRankOptionItem, I18n.getLabel("club.change-member-rank.title"), I18n.getLabel("club.change-member-rank.select-rank.label"));
            if (rank.isPresent()) {
                CorePlayer playerToSet = (CorePlayer)this.playerRepository.findByKey(playerId);
                ClubRank clubRank = (ClubRank)this.clubRankRepository.findByKey(rank.get().rankId());
                playerToSet.getClub().setRank(clubRank);
                return ResponseFactory.success(I18n.getLabel("club.change-member-rank.title"), I18n.getLabel("club.change-member-rank.success"), () -> this.showClubMembersMenu(player, club.getId(), 1));
            }
            return ResponseFactory.fail();
        }
        catch (ClubPermissionException | PlayerNotInClubException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex, () -> this.showClubMembersMenu(player, club.getId(), 1));
        }
    }

    private OptionPromptItem<ClubRankInfo> buildRankOptionItem(final ClubRankInfo clubRankInfo) {
        return new OptionPromptItem<ClubRankInfo>(){

            @Override
            public int getId() {
                return clubRankInfo.rankId();
            }

            @Override
            public String getName() {
                return clubRankInfo.rankName();
            }

            @Override
            public ClubRankInfo getItem() {
                return clubRankInfo;
            }
        };
    }

    @Override
    public Response createRank(OnlinePlayer player) {
        Club club = player.getClub().getClub().orElseThrow();
        try {
            List<ClubPermissionLevel> items;
            Optional<ClubPermissionLevel> level;
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.EDIT_DETAILS);
            Optional<String> name = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("club.create-rank.title"), I18n.getLabel("club.create-rank.name.label"));
            if (name.isPresent() && (level = SingleSelectionOptionPrompt.showOptionPrompt(player, items = Arrays.stream(ClubPermissionLevel.values()).toList(), this::buildPermissionLevelOptionItem, I18n.getLabel("club.create-rank.title"), I18n.getLabel("club.create-rank.permission.label"))).isPresent()) {
                this.clubRankSession.createClubRank(club, name.get(), level.get());
                return ResponseFactory.success(I18n.getLabel("club.create-rank.title"), I18n.getLabel("club.create-rank.success.message"), () -> this.showClubRankPage(player, club.getId(), 1));
            }
            return ResponseFactory.fail();
        }
        catch (ClubPermissionException | ClubRankException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex, () -> this.showClubRankPage(player, club.getId(), 1));
        }
    }

    private OptionPromptItem<ClubPermissionLevel> buildPermissionLevelOptionItem(final ClubPermissionLevel clubPermissionLevel) {
        return new OptionPromptItem<ClubPermissionLevel>(){

            @Override
            public int getId() {
                return clubPermissionLevel.ordinal();
            }

            @Override
            public String getName() {
                return clubPermissionLevel.getTranslatedName();
            }

            @Override
            public String getDescription() {
                return clubPermissionLevel.getTranslatedDescription();
            }

            @Override
            public ClubPermissionLevel getItem() {
                return clubPermissionLevel;
            }
        };
    }

    @Override
    public Response changeRanksName(OnlinePlayer player, int rankId) {
        Club club = player.getClub().getClub().orElseThrow();
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.EDIT_DETAILS);
            Optional<String> name = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("club.edit-rank.title"), I18n.getLabel("club.edit-rank.name.label"));
            if (name.isPresent()) {
                this.clubRankSession.updateClubRankName(rankId, name.get());
                return ResponseFactory.success(I18n.getLabel("club.edit-rank.title"), I18n.getLabel("club.edit-rank.success"), () -> this.showClubRankPage(player, club.getId(), 1));
            }
            return ResponseFactory.fail();
        }
        catch (ClubPermissionException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), (Exception)ex, () -> this.showClubRankPage(player, club.getId(), 1));
        }
    }

    @Override
    public Response changeRanksPermissionLevel(OnlinePlayer player, int rankId) {
        Club club = player.getClub().getClub().orElseThrow();
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.EDIT_DETAILS);
            List<ClubPermissionLevel> items = Arrays.stream(ClubPermissionLevel.values()).toList();
            Optional<ClubPermissionLevel> level = SingleSelectionOptionPrompt.showOptionPrompt(player, items, this::buildPermissionLevelOptionItem, I18n.getLabel("club.edit-rank.title"), I18n.getLabel("club.edit-rank.permission.label"));
            if (level.isPresent()) {
                this.clubRankSession.updateClubRankPermissionLevel(rankId, level.get());
                return ResponseFactory.success(I18n.getLabel("club.edit-rank.title"), I18n.getLabel("club.edit-rank.success"), () -> this.showClubRankPage(player, club.getId(), 1));
            }
            return ResponseFactory.fail();
        }
        catch (ClubPermissionException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), (Exception)ex, () -> this.showClubRankPage(player, club.getId(), 1));
        }
    }

    @Override
    public Response changeClubsDefaultRank(OnlinePlayer player, int rankId) {
        Club club = player.getClub().getClub().orElseThrow();
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.EDIT_DETAILS);
            this.clubRankSession.setClubsDefaultRank(club.getId(), rankId);
            return ResponseFactory.success(I18n.getLabel("club.edit-rank.title"), I18n.getLabel("club.edit-rank.success"), () -> this.showClubRankPage(player, club.getId(), 1));
        }
        catch (ClubPermissionException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), (Exception)ex, () -> this.showClubRankPage(player, club.getId(), 1));
        }
    }

    @Override
    public Response givePlayerClubPlus(OnlinePlayer player) {
        player.getCorePlayer().setClubPlus(true);
        player.getCorePlayer().save();
        return ResponseFactory.success();
    }

    @Override
    public Response transferClubToAdmin(OnlinePlayer player, int newOwnerId) {
        try {
            ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.TRANSFER_CLUB);
            CorePlayer newOwner = (CorePlayer)this.playerRepository.findByKey(newOwnerId);
            Club club = player.getClub().getClub().orElseThrow();
            this.clubSession.transferClubToAdmin(club.getId(), newOwner);
            return ResponseFactory.success();
        }
        catch (ClubPermissionException | PlayerNotClubAdminException | PlayerNotInClubException | CannotUpdateAccountException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex);
        }
    }

    @Override
    public Response disbandClub(OnlinePlayer player) {
        try {
            ConfirmResponse confirm = player.getConfirmation().confirm(I18n.getLabel("club.disband.confirm-prompt.title"), I18n.getLabel("club.disband.confirm-prompt.message"));
            if (confirm.isYes()) {
                ClubPermissionChecker.ensureHasClubPermission(player, ClubPermission.DISBAND_CLUB);
                Club club = player.getClub().getClub().orElseThrow();
                this.clubSession.disbandClub(club);
                return ResponseFactory.success(I18n.getLabel("club.disband.success.prompt.title"), I18n.getLabel("club.disband.success.message", club.getName()));
            }
            this.showClubManageMenu(player);
            return ResponseFactory.fail();
        }
        catch (ClubPermissionException | EconomyException ex) {
            return ResponseFactory.fail(I18n.getLabel("club.title"), ex);
        }
    }
}

