/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.collectable;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.collectable.CollectableService;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.BlockPosUtil;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class CollectableListener {
    @Service
    private static CollectableService collectableService;
    private static final OnlinePlayerCache onlinePlayerCache;

    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == InteractionHand.MAIN_HAND) {
            OnlinePlayer player = onlinePlayerCache.requirePlayer(event.getPlayer().m_142081_()).require(OnlinePlayer.class);
            BlockCoordinate blockCoordinate = BlockPosUtil.toBlockCoordinate(event.getPos(), player.getECLevel());
            TaskScheduler.executeAsyncTask(() -> {
                Response response = collectableService.processCollectableAtLocation(player, blockCoordinate);
                player.showResponse(response);
            });
        }
    }

    private CollectableListener() {
    }

    static {
        onlinePlayerCache = OnlinePlayerCache.getInstance();
    }
}

