/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.collectable;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.collectable.CannotGetCollectableException;
import com.equestricraft.core.collectable.CollectableSession;
import com.equestricraft.core.collectable.FoundCollectableResponse;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.collectable.CollectableService;

public class CollectableServiceImpl
implements CollectableService {
    @Service
    private CollectableSession collectableSession;

    @Override
    public Response processCollectableAtLocation(ECPlayer player, BlockCoordinate blockCoordinate) {
        try {
            return this.collectableSession.processCollectableAtLocation(player, blockCoordinate).map(this::toResponse).orElseGet(ResponseFactory::fail);
        }
        catch (CannotGetCollectableException ex) {
            return ResponseFactory.fail(ex);
        }
    }

    @Override
    public Response processCollectable(ECPlayer player, int collectableId) {
        try {
            FoundCollectableResponse response = player.getCollectables().give(collectableId);
            return this.toResponse(response);
        }
        catch (CannotGetCollectableException ex) {
            return ResponseFactory.fail(ex);
        }
    }

    private Response toResponse(FoundCollectableResponse response) {
        if (response.wasGroupCompleted()) {
            return ResponseFactory.success(I18n.getLabel("collectable.group-completed", response.completedGroup()));
        }
        return ResponseFactory.success(I18n.getLabel("collectable.found"));
    }
}

